/*
 * Decompiled with CFR 0.152.
 */
package com.meilisearch.sdk;

import com.meilisearch.sdk.Config;
import com.meilisearch.sdk.HttpClient;
import com.meilisearch.sdk.exceptions.MeilisearchException;
import com.meilisearch.sdk.http.URLBuilder;
import com.meilisearch.sdk.model.DocumentQuery;
import com.meilisearch.sdk.model.DocumentsQuery;
import com.meilisearch.sdk.model.Results;
import com.meilisearch.sdk.model.TaskInfo;
import java.util.List;

class Documents {
    private final HttpClient httpClient;

    protected Documents(Config config) {
        this.httpClient = config.httpClient;
    }

    <T> T getDocument(String uid, String identifier, Class<T> targetClass) throws MeilisearchException {
        return this.httpClient.get(this.documentPath(uid, identifier).getURL(), targetClass, new Class[0]);
    }

    <T> T getDocument(String uid, String identifier, DocumentQuery param, Class<T> targetClass) throws MeilisearchException {
        return this.httpClient.get(this.documentPath(uid, identifier).addQuery(param.toQuery()).getURL(), targetClass, new Class[0]);
    }

    String getRawDocument(String uid, String identifier) throws MeilisearchException {
        return this.httpClient.get(this.documentPath(uid, identifier).getURL(), String.class, new Class[0]);
    }

    String getRawDocument(String uid, String identifier, DocumentQuery param) throws MeilisearchException {
        return this.httpClient.get(this.documentPath(uid, identifier).addQuery(param.toQuery()).getURL(), String.class, new Class[0]);
    }

    <T> Results<T> getDocuments(String uid, Class<T> targetClass) throws MeilisearchException {
        return this.httpClient.get(this.documentPath(uid).getURL(), Results.class, targetClass);
    }

    <T> Results<T> getDocuments(String uid, DocumentsQuery param, Class<T> targetClass) throws MeilisearchException {
        return this.httpClient.get(this.documentPath(uid).addQuery(param.toQuery()).getURL(), Results.class, targetClass);
    }

    String getRawDocuments(String uid) throws MeilisearchException {
        return this.httpClient.get(this.documentPath(uid).getURL(), String.class, new Class[0]);
    }

    String getRawDocuments(String uid, DocumentsQuery param) throws MeilisearchException {
        return this.httpClient.get(this.documentPath(uid).addQuery(param.toQuery()).getURL(), String.class, new Class[0]);
    }

    TaskInfo addDocuments(String uid, String document, String primaryKey) throws MeilisearchException {
        URLBuilder urlb = this.documentPath(uid);
        if (primaryKey != null) {
            urlb.addParameter("primaryKey", primaryKey);
        }
        return this.httpClient.post(urlb.getURL(), document, TaskInfo.class);
    }

    TaskInfo updateDocuments(String uid, String document, String primaryKey) throws MeilisearchException {
        URLBuilder urlb = this.documentPath(uid);
        if (primaryKey != null) {
            urlb.addParameter("primaryKey", primaryKey);
        }
        return this.httpClient.put(urlb.getURL(), document, TaskInfo.class);
    }

    TaskInfo deleteDocument(String uid, String identifier) throws MeilisearchException {
        return this.httpClient.delete(this.documentPath(uid, identifier).getURL(), TaskInfo.class);
    }

    TaskInfo deleteDocuments(String uid, List<String> identifiers) throws MeilisearchException {
        URLBuilder urlb = this.documentPath(uid).addSubroute("delete-batch");
        return this.httpClient.post(urlb.getURL(), identifiers, TaskInfo.class);
    }

    TaskInfo deleteAllDocuments(String uid) throws MeilisearchException {
        return this.httpClient.delete(this.documentPath(uid).getURL(), TaskInfo.class);
    }

    private URLBuilder documentPath(String uid) {
        return new URLBuilder().addSubroute("indexes").addSubroute(uid).addSubroute("documents");
    }

    private URLBuilder documentPath(String uid, String identifier) {
        return new URLBuilder().addSubroute("indexes").addSubroute(uid).addSubroute("documents").addSubroute(identifier);
    }
}

