/*
 * Decompiled with CFR 0.152.
 */
package com.meilisearch.sdk;

import com.meilisearch.sdk.Config;
import com.meilisearch.sdk.Documents;
import com.meilisearch.sdk.HttpClient;
import com.meilisearch.sdk.InstanceHandler;
import com.meilisearch.sdk.Search;
import com.meilisearch.sdk.SearchRequest;
import com.meilisearch.sdk.SettingsHandler;
import com.meilisearch.sdk.TasksHandler;
import com.meilisearch.sdk.exceptions.MeilisearchException;
import com.meilisearch.sdk.model.DocumentQuery;
import com.meilisearch.sdk.model.DocumentsQuery;
import com.meilisearch.sdk.model.Faceting;
import com.meilisearch.sdk.model.IndexStats;
import com.meilisearch.sdk.model.Pagination;
import com.meilisearch.sdk.model.Results;
import com.meilisearch.sdk.model.SearchResult;
import com.meilisearch.sdk.model.Searchable;
import com.meilisearch.sdk.model.Settings;
import com.meilisearch.sdk.model.Task;
import com.meilisearch.sdk.model.TaskInfo;
import com.meilisearch.sdk.model.TasksQuery;
import com.meilisearch.sdk.model.TasksResults;
import com.meilisearch.sdk.model.TypoTolerance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;

public class Index
implements Serializable {
    protected String uid;
    protected String primaryKey;
    protected String createdAt;
    protected Pagination pagination;
    protected Faceting faceting;
    protected String updatedAt;
    protected Config config;
    protected Documents documents;
    protected TasksHandler tasksHandler;
    protected Search search;
    protected SettingsHandler settingsHandler;
    protected InstanceHandler instanceHandler;

    void setConfig(Config config) {
        this.config = config;
        this.documents = new Documents(config);
        this.tasksHandler = new TasksHandler(config);
        this.search = new Search(config);
        this.settingsHandler = new SettingsHandler(config);
        this.instanceHandler = new InstanceHandler(config);
    }

    public <T> T getDocument(String identifier, Class<T> targetClass) throws MeilisearchException {
        return this.documents.getDocument(this.uid, identifier, targetClass);
    }

    public <T> T getDocument(String identifier, DocumentQuery param, Class<T> targetClass) throws MeilisearchException {
        return this.documents.getDocument(this.uid, identifier, param, targetClass);
    }

    public String getRawDocument(String identifier) throws MeilisearchException {
        return this.documents.getRawDocument(this.uid, identifier);
    }

    public String getRawDocument(String identifier, DocumentQuery param) throws MeilisearchException {
        return this.documents.getRawDocument(this.uid, identifier, param);
    }

    public <T> Results<T> getDocuments(Class<T> targetClass) throws MeilisearchException {
        return this.documents.getDocuments(this.uid, targetClass);
    }

    public <T> Results<T> getDocuments(DocumentsQuery param, Class<T> targetClass) throws MeilisearchException {
        return this.documents.getDocuments(this.uid, param, targetClass);
    }

    public String getRawDocuments() throws MeilisearchException {
        return this.documents.getRawDocuments(this.uid);
    }

    public String getRawDocuments(DocumentsQuery param) throws MeilisearchException {
        return this.documents.getRawDocuments(this.uid, param);
    }

    public TaskInfo addDocuments(String document) throws MeilisearchException {
        return this.documents.addDocuments(this.uid, document, null);
    }

    public TaskInfo addDocuments(String document, String primaryKey) throws MeilisearchException {
        return this.documents.addDocuments(this.uid, document, primaryKey);
    }

    public TaskInfo[] addDocumentsInBatches(String document, Integer batchSize, String primaryKey) throws MeilisearchException {
        JSONArray jsonDocumentsArray = new JSONArray(document);
        JSONArray jsonSubArray = new JSONArray();
        ArrayList<TaskInfo> arrayResponses = new ArrayList<TaskInfo>();
        batchSize = jsonDocumentsArray.length() < batchSize ? jsonDocumentsArray.length() : batchSize.intValue();
        for (int i = 0; i < jsonDocumentsArray.length(); i += batchSize.intValue()) {
            for (int j = 0; j < batchSize && j + i < jsonDocumentsArray.length(); ++j) {
                jsonSubArray.put(j, jsonDocumentsArray.get(i + j));
            }
            arrayResponses.add(this.documents.addDocuments(this.uid, jsonSubArray.toString(), primaryKey));
        }
        return arrayResponses.toArray(new TaskInfo[arrayResponses.size()]);
    }

    public TaskInfo[] addDocumentsInBatches(String document) throws MeilisearchException {
        return this.addDocumentsInBatches(document, 1000, null);
    }

    public TaskInfo updateDocuments(String document) throws MeilisearchException {
        return this.documents.updateDocuments(this.uid, document, null);
    }

    public TaskInfo updateDocuments(String document, String primaryKey) throws MeilisearchException {
        return this.documents.updateDocuments(this.uid, document, primaryKey);
    }

    public TaskInfo[] updateDocumentsInBatches(String document, Integer batchSize, String primaryKey) throws MeilisearchException {
        JSONArray jsonDocumentsArray = new JSONArray(document);
        JSONArray jsonSubArray = new JSONArray();
        ArrayList<TaskInfo> arrayResponses = new ArrayList<TaskInfo>();
        batchSize = jsonDocumentsArray.length() < batchSize ? jsonDocumentsArray.length() : batchSize.intValue();
        for (int i = 0; i < jsonDocumentsArray.length(); i += batchSize.intValue()) {
            for (int j = 0; j < batchSize && j + i < jsonDocumentsArray.length(); ++j) {
                jsonSubArray.put(j, jsonDocumentsArray.get(i + j));
            }
            arrayResponses.add(this.documents.updateDocuments(this.uid, jsonSubArray.toString(), primaryKey));
        }
        return arrayResponses.toArray(new TaskInfo[arrayResponses.size()]);
    }

    public TaskInfo[] updateDocumentsInBatches(String document) throws MeilisearchException {
        return this.updateDocumentsInBatches(document, 1000, null);
    }

    public TaskInfo deleteDocument(String identifier) throws MeilisearchException {
        return this.documents.deleteDocument(this.uid, identifier);
    }

    public TaskInfo deleteDocuments(List<String> documentsIdentifiers) throws MeilisearchException {
        return this.documents.deleteDocuments(this.uid, documentsIdentifiers);
    }

    public TaskInfo deleteAllDocuments() throws MeilisearchException {
        return this.documents.deleteAllDocuments(this.uid);
    }

    public SearchResult search(String q) throws MeilisearchException {
        return this.search.search(this.uid, q);
    }

    public Searchable search(SearchRequest searchRequest) throws MeilisearchException {
        return this.search.search(this.uid, searchRequest);
    }

    public String rawSearch(String query) throws MeilisearchException {
        return this.search.rawSearch(this.uid, query);
    }

    public String rawSearch(SearchRequest searchRequest) throws MeilisearchException {
        return this.search.rawSearch(this.uid, searchRequest);
    }

    public Settings getSettings() throws MeilisearchException {
        return this.settingsHandler.getSettings(this.uid);
    }

    public TaskInfo updateSettings(Settings settings) throws MeilisearchException {
        return this.settingsHandler.updateSettings(this.uid, settings);
    }

    public TaskInfo resetSettings() throws MeilisearchException {
        return this.settingsHandler.resetSettings(this.uid);
    }

    public String[] getRankingRulesSettings() throws MeilisearchException {
        return this.settingsHandler.getRankingRulesSettings(this.uid);
    }

    public TaskInfo updateRankingRulesSettings(String[] rankingRules) throws MeilisearchException {
        return this.settingsHandler.updateRankingRulesSettings(this.uid, rankingRules);
    }

    public TaskInfo resetRankingRulesSettings() throws MeilisearchException {
        return this.settingsHandler.resetRankingRulesSettings(this.uid);
    }

    public Map<String, String[]> getSynonymsSettings() throws MeilisearchException {
        return this.settingsHandler.getSynonymsSettings(this.uid);
    }

    public TaskInfo updateSynonymsSettings(Map<String, String[]> synonyms) throws MeilisearchException {
        return this.settingsHandler.updateSynonymsSettings(this.uid, synonyms);
    }

    public TaskInfo resetSynonymsSettings() throws MeilisearchException {
        return this.settingsHandler.resetSynonymsSettings(this.uid);
    }

    public String[] getStopWordsSettings() throws MeilisearchException {
        return this.settingsHandler.getStopWordsSettings(this.uid);
    }

    public TaskInfo updateStopWordsSettings(String[] stopWords) throws MeilisearchException {
        return this.settingsHandler.updateStopWordsSettings(this.uid, stopWords);
    }

    public TaskInfo resetStopWordsSettings() throws MeilisearchException {
        return this.settingsHandler.resetStopWordsSettings(this.uid);
    }

    public String[] getSearchableAttributesSettings() throws MeilisearchException {
        return this.settingsHandler.getSearchableAttributesSettings(this.uid);
    }

    public TaskInfo updateSearchableAttributesSettings(String[] searchableAttributes) throws MeilisearchException {
        return this.settingsHandler.updateSearchableAttributesSettings(this.uid, searchableAttributes);
    }

    public TaskInfo resetSearchableAttributesSettings() throws MeilisearchException {
        return this.settingsHandler.resetSearchableAttributesSettings(this.uid);
    }

    public String[] getDisplayedAttributesSettings() throws MeilisearchException {
        return this.settingsHandler.getDisplayedAttributesSettings(this.uid);
    }

    public TaskInfo updateDisplayedAttributesSettings(String[] displayAttributes) throws MeilisearchException {
        return this.settingsHandler.updateDisplayedAttributesSettings(this.uid, displayAttributes);
    }

    public TaskInfo resetDisplayedAttributesSettings() throws MeilisearchException {
        return this.settingsHandler.resetDisplayedAttributesSettings(this.uid);
    }

    public String[] getFilterableAttributesSettings() throws MeilisearchException {
        return this.settingsHandler.getFilterableAttributesSettings(this.uid);
    }

    public TaskInfo updateFilterableAttributesSettings(String[] filterableAttributes) throws MeilisearchException {
        return this.settingsHandler.updateFilterableAttributesSettings(this.uid, filterableAttributes);
    }

    public TaskInfo resetFilterableAttributesSettings() throws MeilisearchException {
        return this.settingsHandler.resetFilterableAttributesSettings(this.uid);
    }

    public String[] getSortableAttributesSettings() throws MeilisearchException {
        return this.settingsHandler.getSortableAttributesSettings(this.uid);
    }

    public TaskInfo updateSortableAttributesSettings(String[] sortableAttributes) throws MeilisearchException {
        return this.settingsHandler.updateSortableAttributesSettings(this.uid, sortableAttributes);
    }

    public TaskInfo resetSortableAttributesSettings() throws MeilisearchException {
        return this.settingsHandler.resetSortableAttributesSettings(this.uid);
    }

    public String getDistinctAttributeSettings() throws MeilisearchException {
        return this.settingsHandler.getDistinctAttributeSettings(this.uid);
    }

    public TaskInfo updateDistinctAttributeSettings(String distinctAttribute) throws MeilisearchException {
        return this.settingsHandler.updateDistinctAttributeSettings(this.uid, distinctAttribute);
    }

    public TaskInfo resetDistinctAttributeSettings() throws MeilisearchException {
        return this.settingsHandler.resetDistinctAttributeSettings(this.uid);
    }

    public TypoTolerance getTypoToleranceSettings() throws MeilisearchException {
        return this.settingsHandler.getTypoToleranceSettings(this.uid);
    }

    public TaskInfo updateTypoToleranceSettings(TypoTolerance typoTolerance) throws MeilisearchException {
        return this.settingsHandler.updateTypoToleranceSettings(this.uid, typoTolerance);
    }

    public TaskInfo resetTypoToleranceSettings() throws MeilisearchException {
        return this.settingsHandler.resetTypoToleranceSettings(this.uid);
    }

    public Pagination getPaginationSettings() throws MeilisearchException {
        return this.settingsHandler.getPaginationSettings(this.uid);
    }

    public TaskInfo updatePaginationSettings(Pagination pagination) throws MeilisearchException {
        return this.settingsHandler.updatePaginationSettings(this.uid, pagination);
    }

    public TaskInfo resetPaginationSettings() throws MeilisearchException {
        return this.settingsHandler.resetPaginationSettings(this.uid);
    }

    public Faceting getFacetingSettings() throws MeilisearchException {
        return this.settingsHandler.getFacetingSettings(this.uid);
    }

    public TaskInfo updateFacetingSettings(Faceting faceting) throws MeilisearchException {
        return this.settingsHandler.updateFacetingSettings(this.uid, faceting);
    }

    public TaskInfo resetFacetingSettings() throws MeilisearchException {
        return this.settingsHandler.resetFacetingSettings(this.uid);
    }

    public IndexStats getStats() throws MeilisearchException {
        return this.instanceHandler.getIndexStats(this.uid);
    }

    public Task getTask(int taskId) throws MeilisearchException {
        return this.tasksHandler.getTask(taskId);
    }

    public TasksResults getTasks() throws MeilisearchException {
        return this.tasksHandler.getTasks(this.uid);
    }

    public TasksResults getTasks(TasksQuery param) throws MeilisearchException {
        return this.tasksHandler.getTasks(this.uid, param);
    }

    public void waitForTask(int taskId) throws MeilisearchException {
        this.tasksHandler.waitForTask(taskId, 5000, 50);
    }

    public void waitForTask(int taskId, int timeoutInMs, int intervalInMs) throws MeilisearchException {
        this.tasksHandler.waitForTask(taskId, timeoutInMs, intervalInMs);
    }

    public void fetchPrimaryKey() throws MeilisearchException {
        String requestQuery = "/indexes/" + this.uid;
        HttpClient httpClient = this.config.httpClient;
        Index retrievedIndex = httpClient.get(requestQuery, Index.class, new Class[0]);
        this.primaryKey = retrievedIndex.getPrimaryKey();
    }

    public String toString() {
        return "Index(uid=" + this.getUid() + ", primaryKey=" + this.getPrimaryKey() + ", createdAt=" + this.getCreatedAt() + ", pagination=" + this.getPagination() + ", faceting=" + this.getFaceting() + ")";
    }

    public String getUid() {
        return this.uid;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public Faceting getFaceting() {
        return this.faceting;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public Config getConfig() {
        return this.config;
    }
}

