/*
 * Decompiled with CFR 0.152.
 */
package com.meilisearch.sdk;

import com.meilisearch.sdk.Config;
import com.meilisearch.sdk.HttpClient;
import com.meilisearch.sdk.Index;
import com.meilisearch.sdk.exceptions.MeilisearchException;
import com.meilisearch.sdk.http.URLBuilder;
import com.meilisearch.sdk.model.IndexesQuery;
import com.meilisearch.sdk.model.Results;
import com.meilisearch.sdk.model.TaskInfo;
import java.util.HashMap;

class IndexesHandler {
    private final HttpClient httpClient;

    protected IndexesHandler(Config config) {
        this.httpClient = config.httpClient;
    }

    TaskInfo createIndex(String uid) throws MeilisearchException {
        return this.createIndex(uid, null);
    }

    TaskInfo createIndex(String uid, String primaryKey) throws MeilisearchException {
        HashMap<String, String> index = new HashMap<String, String>();
        index.put("uid", uid);
        index.put("primaryKey", primaryKey);
        return this.httpClient.post(this.indexesPath().getURL(), index, TaskInfo.class);
    }

    Index getIndex(String uid) throws MeilisearchException {
        return this.httpClient.get(this.indexesPath().addSubroute(uid).getURL(), Index.class, new Class[0]);
    }

    Results<Index> getIndexes() throws MeilisearchException {
        return this.httpClient.get(this.indexesPath().getURL(), Results.class, Index.class);
    }

    Results<Index> getIndexes(IndexesQuery params) throws MeilisearchException {
        return this.httpClient.get(this.indexesPath().addQuery(params.toQuery()).getURL(), Results.class, Index.class);
    }

    String getRawIndexes() throws MeilisearchException {
        return this.httpClient.get(this.indexesPath().getURL(), String.class, new Class[0]);
    }

    String getRawIndexes(IndexesQuery params) throws MeilisearchException {
        return this.httpClient.get(this.indexesPath().addQuery(params.toQuery()).getURL(), String.class, new Class[0]);
    }

    TaskInfo updatePrimaryKey(String uid, String primaryKey) throws MeilisearchException {
        HashMap<String, String> index = new HashMap<String, String>();
        index.put("primaryKey", primaryKey);
        return this.httpClient.patch(this.indexesPath().addSubroute(uid).getURL(), index, TaskInfo.class);
    }

    TaskInfo deleteIndex(String uid) throws MeilisearchException {
        return this.httpClient.delete(this.indexesPath().addSubroute(uid).getURL(), TaskInfo.class);
    }

    private URLBuilder indexesPath() {
        return new URLBuilder("/indexes");
    }
}

