/*
 * Decompiled with CFR 0.152.
 */
package com.meilisearch.sdk;

import com.meilisearch.sdk.Config;
import com.meilisearch.sdk.HttpClient;
import com.meilisearch.sdk.exceptions.MeilisearchException;
import com.meilisearch.sdk.exceptions.MeilisearchTimeoutException;
import com.meilisearch.sdk.http.URLBuilder;
import com.meilisearch.sdk.model.CancelTasksQuery;
import com.meilisearch.sdk.model.DeleteTasksQuery;
import com.meilisearch.sdk.model.Task;
import com.meilisearch.sdk.model.TaskInfo;
import com.meilisearch.sdk.model.TaskStatus;
import com.meilisearch.sdk.model.TasksQuery;
import com.meilisearch.sdk.model.TasksResults;
import java.util.Date;

public class TasksHandler {
    private final HttpClient httpClient;

    protected TasksHandler(Config config) {
        this.httpClient = config.httpClient;
    }

    Task getTask(int taskUid) throws MeilisearchException {
        URLBuilder urlb = new URLBuilder();
        urlb.addSubroute("tasks").addSubroute(Integer.toString(taskUid));
        String urlPath = urlb.getURL();
        return this.httpClient.get(urlPath, Task.class, new Class[0]);
    }

    TasksResults getTasks() throws MeilisearchException {
        TasksResults result = this.httpClient.get(this.tasksPath().getURL(), TasksResults.class, new Class[0]);
        return result;
    }

    TasksResults getTasks(TasksQuery param) throws MeilisearchException {
        TasksResults result = this.httpClient.get(this.tasksPath().addQuery(param.toQuery()).getURL(), TasksResults.class, new Class[0]);
        return result;
    }

    TasksResults getTasks(String indexUid) throws MeilisearchException {
        URLBuilder urlb = this.tasksPath().addParameter("indexUid", indexUid);
        TasksResults result = this.httpClient.get(urlb.getURL(), TasksResults.class, new Class[0]);
        return result;
    }

    TasksResults getTasks(String indexUid, TasksQuery param) throws MeilisearchException {
        param = this.addIndexUidToQuery(indexUid, param);
        TasksResults result = this.httpClient.get(this.tasksPath().addQuery(param.toQuery()).getURL(), TasksResults.class, new Class[0]);
        return result;
    }

    TaskInfo cancelTasks(CancelTasksQuery param) throws MeilisearchException {
        URLBuilder urlb = this.tasksPath().addSubroute("cancel");
        TaskInfo result = this.httpClient.post(urlb.addQuery(param.toQuery()).getURL(), null, TaskInfo.class);
        return result;
    }

    TaskInfo deleteTasks(DeleteTasksQuery param) throws MeilisearchException {
        TaskInfo result = this.httpClient.delete(this.tasksPath().addQuery(param.toQuery()).getURL(), TaskInfo.class);
        return result;
    }

    void waitForTask(int taskUid) throws MeilisearchException {
        this.waitForTask(taskUid, 5000, 50);
    }

    void waitForTask(int taskUid, int timeoutInMs, int intervalInMs) throws MeilisearchException {
        Enum status = null;
        long startTime = new Date().getTime();
        long elapsedTime = 0L;
        while (status == null || !status.equals((Object)TaskStatus.SUCCEEDED) && !status.equals((Object)TaskStatus.FAILED)) {
            if (elapsedTime >= (long)timeoutInMs) {
                throw new MeilisearchTimeoutException();
            }
            Task task = this.getTask(taskUid);
            status = task.getStatus();
            try {
                Thread.sleep(intervalInMs);
            }
            catch (Exception e) {
                throw new MeilisearchTimeoutException();
            }
            elapsedTime = new Date().getTime() - startTime;
        }
    }

    private URLBuilder tasksPath() {
        return new URLBuilder("/tasks");
    }

    TasksQuery addIndexUidToQuery(String indexUid, TasksQuery param) {
        if (param != null && param.getIndexUids() != null) {
            String[] newIndexUid = new String[param.getIndexUids().length + 1];
            for (int i = 0; i < param.getIndexUids().length; ++i) {
                newIndexUid[i] = param.getIndexUids()[i];
            }
            newIndexUid[param.getIndexUids().length] = indexUid;
            param.setIndexUids(newIndexUid);
        } else if (param != null) {
            param.setIndexUids(new String[]{indexUid});
        } else {
            param = new TasksQuery().setIndexUids(new String[]{indexUid});
        }
        return param;
    }
}

