/*
 * Decompiled with CFR 0.152.
 */
package com.meilisearch.sdk.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.meilisearch.sdk.exceptions.JsonDecodingException;
import com.meilisearch.sdk.exceptions.JsonEncodingException;
import com.meilisearch.sdk.exceptions.MeilisearchException;
import com.meilisearch.sdk.json.JsonHandler;
import com.meilisearch.sdk.model.Key;
import java.io.IOException;
import java.text.DateFormat;

public class JacksonJsonHandler
implements JsonHandler {
    private final ObjectMapper mapper;

    public JacksonJsonHandler() {
        this.mapper = new ObjectMapper();
        this.mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.mapper.setDateFormat((DateFormat)new StdDateFormat().withColonInTimeZone(true));
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public JacksonJsonHandler(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public String encode(Object o) throws MeilisearchException {
        if (o != null && o.getClass() == String.class) {
            return (String)o;
        }
        try {
            if (o != null && o.getClass() != Key.class) {
                this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            }
            return this.mapper.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new JsonEncodingException((Exception)((Object)e));
        }
    }

    @Override
    public <T> T decode(Object o, Class<?> targetClass, Class<?> ... parameters) throws MeilisearchException {
        if (o == null) {
            throw new JsonDecodingException("Response to deserialize is null");
        }
        if (targetClass == String.class) {
            return (T)o;
        }
        try {
            if (parameters == null || parameters.length == 0) {
                return (T)this.mapper.readValue((String)o, targetClass);
            }
            return (T)this.mapper.readValue((String)o, this.mapper.getTypeFactory().constructParametricType(targetClass, (Class[])parameters));
        }
        catch (IOException e) {
            throw new JsonDecodingException(e);
        }
    }
}

