/*
 * Decompiled with CFR 0.152.
 */
package com.meilisearch.sdk;

import com.meilisearch.sdk.Config;
import com.meilisearch.sdk.HttpClient;
import com.meilisearch.sdk.exceptions.MeilisearchException;
import com.meilisearch.sdk.http.URLBuilder;
import com.meilisearch.sdk.model.Key;
import com.meilisearch.sdk.model.KeyUpdate;
import com.meilisearch.sdk.model.KeysQuery;
import com.meilisearch.sdk.model.Results;

public class KeysHandler {
    private final HttpClient httpClient;

    protected KeysHandler(Config config) {
        this.httpClient = config.httpClient;
    }

    Key getKey(String uid) throws MeilisearchException {
        return this.httpClient.get(this.keysPath().addSubroute(uid).getURL(), Key.class, new Class[0]);
    }

    Results<Key> getKeys() throws MeilisearchException {
        return this.httpClient.get(this.keysPath().getURL(), Results.class, Key.class);
    }

    Results<Key> getKeys(KeysQuery params) throws MeilisearchException {
        return this.httpClient.get(this.keysPath().addQuery(params.toQuery()).getURL(), Results.class, Key.class);
    }

    Key createKey(Key options) throws MeilisearchException {
        return this.httpClient.post(this.keysPath().getURL(), options, Key.class, new Class[0]);
    }

    Key updateKey(String key, KeyUpdate options) throws MeilisearchException {
        return this.httpClient.patch(this.keysPath().addSubroute(key).getURL(), options, Key.class);
    }

    void deleteKey(String key) throws MeilisearchException {
        this.httpClient.delete(this.keysPath().addSubroute(key).getURL(), String.class);
    }

    private URLBuilder keysPath() {
        return new URLBuilder("/keys");
    }
}

