/*
 * Decompiled with CFR 0.152.
 */
package com.meitu.platform.lmstfy.client;

import com.meitu.platform.lmstfy.Job;
import com.meitu.platform.lmstfy.client.OkHttpRetryInterceptor;
import com.meitu.platform.lmstfy.exception.LmstfyException;
import com.meitu.platform.lmstfy.exception.LmstfyIllegalRequestException;
import com.meitu.platform.lmstfy.exception.LmstfyNotJobException;
import com.meitu.platform.lmstfy.exception.LmstfyUnexpectedException;
import com.meitu.platform.lmstfy.response.DeadLetterResponse;
import com.meitu.platform.lmstfy.response.ErrorResponse;
import com.meitu.platform.lmstfy.response.LmstfyResponse;
import com.meitu.platform.lmstfy.response.PublishResponse;
import com.meitu.platform.lmstfy.response.QueueSizeResponse;
import com.meitu.platform.lmstfy.response.RespawnResponse;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class LmstfyClient {
    private static final String HEADER_TOKEN = "X-Token";
    private static final String PATH_API = "api";
    private static final String QUERY_DELAY = "delay";
    private static final String QUERY_TTL = "ttl";
    private static final String QUERY_TRIES = "tries";
    private static final String QUERY_TIMEOUT = "timeout";
    private static final String QUERY_TTR = "ttr";
    private static final String QUERY_LIMIT = "limit";
    private static final String QUERY_COUNT = "count";
    private String namespace;
    private String token;
    private OkHttpClient http;
    private HttpUrl serviceAddress;

    public LmstfyClient(String host, int port, String namespace, String token, int readTimeoutSecond, int writeTimeoutSecond, int connectTimeoutSecond, int retryTimes, int retryIntervalMilliseconds) {
        this.namespace = namespace;
        this.token = token;
        this.serviceAddress = new HttpUrl.Builder().host(host).port(port).scheme("http").build();
        this.http = new OkHttpClient.Builder().retryOnConnectionFailure(true).addInterceptor((Interceptor)new OkHttpRetryInterceptor(retryTimes, retryIntervalMilliseconds)).readTimeout((long)readTimeoutSecond, TimeUnit.SECONDS).writeTimeout((long)writeTimeoutSecond, TimeUnit.SECONDS).connectTimeout((long)connectTimeoutSecond, TimeUnit.SECONDS).connectionPool(new ConnectionPool(100, 5L, TimeUnit.MINUTES)).build();
    }

    public LmstfyClient(String host, int port, String namespace, String token) {
        this(host, port, namespace, token, 600, 600, 5, 3, 100);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LmstfyResponse doRequest(String method, HttpUrl url, RequestBody body) throws LmstfyException {
        Request request = new Request.Builder().url(url).addHeader(HEADER_TOKEN, this.token).method(method, body).build();
        try (Response response = this.http.newCall(request).execute();){
            LmstfyResponse lmstfyResponse = new LmstfyResponse(response);
            return lmstfyResponse;
        }
        catch (IOException e) {
            throw new LmstfyException("request lmstfy failed", e);
        }
    }

    public String publish(String queue, byte[] data, int ttlSecond, short tries, int delaySecond) throws LmstfyException {
        HttpUrl url = this.genServiceUrlBuilder(PATH_API, this.namespace, queue).addQueryParameter(QUERY_DELAY, String.valueOf(delaySecond)).addQueryParameter(QUERY_TTL, String.valueOf(ttlSecond)).addQueryParameter(QUERY_TRIES, String.valueOf(tries)).build();
        LmstfyResponse response = this.doRequest("PUT", url, RequestBody.create((MediaType)MediaType.parse((String)"text/binary"), (byte[])data));
        switch (response.getCode()) {
            case 201: {
                PublishResponse publishResponse = response.unmarshalBody(PublishResponse.class);
                return publishResponse.getJobID();
            }
            case 400: 
            case 413: {
                ErrorResponse errorResponse = response.unmarshalBody(ErrorResponse.class);
                throw new LmstfyIllegalRequestException(response.getCode(), errorResponse.getError());
            }
        }
        throw new LmstfyUnexpectedException(response.getCode());
    }

    public Job consume(int ttrSecond, int timeoutSecond, String ... queues) throws LmstfyException {
        HttpUrl url = this.genServiceUrlBuilder(PATH_API, this.namespace, String.join((CharSequence)",", queues)).addQueryParameter(QUERY_TIMEOUT, String.valueOf(timeoutSecond)).addQueryParameter(QUERY_TTR, String.valueOf(ttrSecond)).addQueryParameter(QUERY_COUNT, String.valueOf(1)).build();
        LmstfyResponse response = this.doRequest("GET", url, null);
        switch (response.getCode()) {
            case 200: {
                return response.unmarshalToJob();
            }
            case 400: {
                ErrorResponse errorResponse = response.unmarshalBody(ErrorResponse.class);
                throw new LmstfyIllegalRequestException(response.getCode(), errorResponse.getError());
            }
            case 404: {
                throw new LmstfyNotJobException();
            }
        }
        throw new LmstfyUnexpectedException(response.getCode());
    }

    public Job[] batchConsume(int count, int ttrSecond, int timeoutSecond, String queue) throws LmstfyException {
        if (count < 1) {
            throw new LmstfyException("consume count must greater than 0");
        }
        if (count == 1) {
            return new Job[]{this.consume(ttrSecond, timeoutSecond, queue)};
        }
        HttpUrl url = this.genServiceUrlBuilder(PATH_API, this.namespace, queue).addQueryParameter(QUERY_TIMEOUT, String.valueOf(timeoutSecond)).addQueryParameter(QUERY_TTR, String.valueOf(ttrSecond)).addQueryParameter(QUERY_COUNT, String.valueOf(count)).build();
        LmstfyResponse response = this.doRequest("GET", url, null);
        switch (response.getCode()) {
            case 200: {
                return response.unmarshalToJobs();
            }
            case 400: {
                ErrorResponse errorResponse = response.unmarshalBody(ErrorResponse.class);
                throw new LmstfyIllegalRequestException(response.getCode(), errorResponse.getError());
            }
            case 404: {
                throw new LmstfyNotJobException();
            }
        }
        throw new LmstfyUnexpectedException(response.getCode());
    }

    public void ack(String queue, String jobID) throws LmstfyException {
        this.delete(queue, jobID);
    }

    public void delete(String queue, String jobID) throws LmstfyException {
        HttpUrl url = this.genServiceUrlBuilder(PATH_API, this.namespace, queue, "job", jobID).build();
        LmstfyResponse response = this.doRequest("DELETE", url, null);
        switch (response.getCode()) {
            case 204: {
                return;
            }
            case 400: {
                ErrorResponse errorResponse = response.unmarshalBody(ErrorResponse.class);
                throw new LmstfyIllegalRequestException(response.getCode(), errorResponse.getError());
            }
        }
        throw new LmstfyUnexpectedException(response.getCode());
    }

    public int queueSize(String queue) throws LmstfyException {
        HttpUrl url = this.genServiceUrlBuilder(PATH_API, this.namespace, queue, "size").build();
        LmstfyResponse response = this.doRequest("GET", url, null);
        switch (response.getCode()) {
            case 200: {
                QueueSizeResponse queueSizeResponse = response.unmarshalBody(QueueSizeResponse.class);
                return queueSizeResponse.getSize();
            }
        }
        throw new LmstfyUnexpectedException(response.getCode());
    }

    public Job peekQueue(String queue) throws LmstfyException {
        HttpUrl url = this.genServiceUrlBuilder(PATH_API, this.namespace, queue, "peek").build();
        return this.peek(url);
    }

    public Job peekJob(String queue, String jobID) throws LmstfyException {
        HttpUrl url = this.genServiceUrlBuilder(PATH_API, this.namespace, queue, "job", jobID).build();
        return this.peek(url);
    }

    public DeadLetterResponse peekDeadLetter(String queue) throws LmstfyException {
        HttpUrl url = this.genServiceUrlBuilder(PATH_API, this.namespace, queue, "deadletter").build();
        LmstfyResponse response = this.doRequest("GET", url, null);
        switch (response.getCode()) {
            case 200: {
                DeadLetterResponse deadLetterResponse = response.unmarshalBody(DeadLetterResponse.class);
                return deadLetterResponse;
            }
        }
        throw new LmstfyUnexpectedException(response.getCode());
    }

    private Job peek(HttpUrl url) throws LmstfyException {
        LmstfyResponse response = this.doRequest("GET", url, null);
        switch (response.getCode()) {
            case 200: {
                return response.unmarshalToJob();
            }
            case 404: {
                return null;
            }
        }
        throw new LmstfyUnexpectedException(response.getCode());
    }

    public int respawnDeadLetter(String queue, int limit, int ttlSecond) throws LmstfyException {
        HttpUrl url = this.genServiceUrlBuilder(PATH_API, this.namespace, queue, "deadletter").addQueryParameter(QUERY_LIMIT, String.valueOf(limit)).addQueryParameter(QUERY_TTL, String.valueOf(ttlSecond)).build();
        LmstfyResponse response = this.doRequest("PUT", url, RequestBody.create((MediaType)MediaType.parse((String)"text/binary"), (byte[])new byte[0]));
        switch (response.getCode()) {
            case 200: {
                RespawnResponse respawnResponse = response.unmarshalBody(RespawnResponse.class);
                return respawnResponse.getCount();
            }
        }
        throw new LmstfyUnexpectedException(response.getCode());
    }

    public void deleteDeadLetter(String queue, int limit) throws LmstfyException {
        HttpUrl url = this.genServiceUrlBuilder(PATH_API, this.namespace, queue, "deadletter").addQueryParameter(QUERY_LIMIT, String.valueOf(limit)).build();
        LmstfyResponse response = this.doRequest("DELETE", url, null);
        switch (response.getCode()) {
            case 204: {
                return;
            }
        }
        throw new LmstfyUnexpectedException(response.getCode());
    }

    private HttpUrl.Builder genServiceUrlBuilder(String ... pathSegments) {
        HttpUrl.Builder builder = this.serviceAddress.newBuilder();
        for (String pathSegment : pathSegments) {
            builder.addPathSegment(pathSegment);
        }
        return builder;
    }
}

