/*
 * Decompiled with CFR 0.152.
 */
package com.meitu.platform.lmstfy.client;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Response;

public class OkHttpRetryInterceptor
implements Interceptor {
    private int retryTimes = 0;
    private long retryIntervalMilliSecond = 0L;

    public OkHttpRetryInterceptor(int retryTimes, long retryIntervalMilliSecond) {
        this.retryTimes = retryTimes;
        this.retryIntervalMilliSecond = retryIntervalMilliSecond;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = null;
        for (int i = 0; i <= this.retryTimes; ++i) {
            response = chain.proceed(chain.request());
            if (response == null || response.code() >= 200 && response.code() < 500) {
                return response;
            }
            if (i >= this.retryTimes || this.retryIntervalMilliSecond <= 0L) continue;
            try {
                Thread.sleep(this.retryIntervalMilliSecond);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return response;
    }
}

