/*
 * Decompiled with CFR 0.152.
 */
package com.meitu.platform.lmstfy.response;

import com.google.gson.Gson;
import com.meitu.platform.lmstfy.Job;
import java.io.IOException;
import java.util.Base64;
import okhttp3.Response;

public class LmstfyResponse {
    private static final String HEADER_REQUEST_ID = "X-Request-ID";
    private Gson gson = new Gson();
    private String body;
    private int code;
    private String requestID;

    public LmstfyResponse(Response response) throws IOException {
        this.code = response.code();
        this.requestID = response.header(HEADER_REQUEST_ID);
        this.body = response.body().string();
    }

    public LmstfyResponse() {
    }

    public String getBody() {
        return this.body;
    }

    public int getCode() {
        return this.code;
    }

    public String getRequestID() {
        return this.requestID;
    }

    public <T> T unmarshalBody(Class<T> tClass) {
        return (T)this.gson.fromJson(this.body, tClass);
    }

    public Job unmarshalToJob() {
        Job job = (Job)this.gson.fromJson(this.body, Job.class);
        if (job.getBase64Data() != null) {
            job.setData(new String(Base64.getDecoder().decode(job.getBase64Data())));
        }
        return job;
    }

    public Job[] unmarshalToJobs() {
        Job[] jobs;
        for (Job job : jobs = (Job[])this.gson.fromJson(this.body, Job[].class)) {
            if (job.getBase64Data() == null) continue;
            job.setData(new String(Base64.getDecoder().decode(job.getBase64Data())));
        }
        return jobs;
    }
}

