package com.meizu.cloud.pushinternal;

import android.content.Context;
import android.os.Environment;
import android.util.Log;

import com.meizu.cloud.pushsdk.common.base.EncryptLogger;
import com.meizu.cloud.pushsdk.common.util.Logger;
import com.meizu.cloud.pushsdk.common.util.Utility;


/**
 * Created by liaojinlong on 16-1-12.
 */
public class DebugLogger {

    public static boolean isOnDebug = false;
    public static boolean debug = BuildConfig.DEBUG;
    private static EncryptLogger encryptLogger;

    public static void initDebugLogger(Context context){
        if(encryptLogger == null){
            encryptLogger = new EncryptLogger(Environment.getExternalStorageDirectory().getAbsolutePath() + "/Android/data/pushSdk/"+context.getPackageName());
            Logger.setCallback(encryptLogger);
            debug = Utility.isApplicationDebug(context);
            //注意其他公共库设置outLevel
            Log.e("DebugLogger", "isOnDebug " + isOnDebug + " debugConfig " + debug + " isDebuggable " + isDebuggable());
            if(!isDebuggable()){
                Logger.setOutLevel(Logger.Out.CONSOLE, Logger.Callback.Level.NULL);
            }
        }
    }

    /**
     * 调解打印输出
     * @param
     * */
    public static void switchDebug(boolean flag){
        isOnDebug = flag;
    }

    public static boolean isDebuggable(){
        return isOnDebug || debug;
    }

    public static void i(String tag,String message){
        Logger.i(tag,message);
    }

    public static void d(String tag,String message){
        Logger.d(tag,message);
    }

    public static void w(String tag,String message){
        Logger.w(tag,message);
    }

    public static void e(String tag,String message){
        Logger.e(tag,message);
    }

}
