package com.meizu.cloud.pushsdk;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.constants.PushConstants;
import com.meizu.cloud.pushsdk.platform.api.PushPlatformManager;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import com.meizu.cloud.pushinternal.BuildConfig;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;


/**
 *
 * PushManager 所有的结果回调都在MzPushReceiver中,请在相应的方法回调中获取结果
 *
 * */
public class PushManager {

    public static final String TAG = BuildConfig.VERSION_NAME;

    static final String PUSH_ID_PREFERENCE_NAME = "com.meizu.flyme.push";
    static final String KEY_PUSH_ID = "pushId";

    /**
     * 向push平台注册push服务,如果该系统下集成了CloudService,则调用pushSerivce进行注册
     *
     * */
     @Deprecated
     public static void register(Context context){
        DebugLogger.initDebugLogger(context);
        String cloudVersionName = MzSystemUtils.getAppVersionName(context, "com.meizu.cloud");
        DebugLogger.i(TAG, context.getPackageName() + " start register cloudVersion_name " + cloudVersionName);
        Intent pushServiceIntent = new Intent(PushConstants.MZ_PUSH_ON_START_PUSH_REGISTER);
        if("com.meizu.cloud".equals(MzSystemUtils.getMzPushServicePackageName(context))){
            pushServiceIntent.setClassName("com.meizu.cloud","com.meizu.cloud.pushsdk.pushservice.MzPushService");
            //兼容云服务低版本获取包名的方法
            pushServiceIntent.putExtra(PushConstants.REGISTER_PACKAGE_NAME,context.getPackageName());
        } else if(!TextUtils.isEmpty(cloudVersionName) && MzSystemUtils.compareVersion(cloudVersionName, "4.5.7")){
            //Flyme 4.0 云服务4.5.7以后版本使用此方法
            //兼容5.0以下版本
            DebugLogger.e(TAG,"flyme 4.x start register cloud versionName "+cloudVersionName);
            pushServiceIntent.setPackage("com.meizu.cloud");
            pushServiceIntent.putExtra(PushConstants.EXTRA_SENDER,context.getPackageName());
        } else if(!TextUtils.isEmpty(cloudVersionName) && cloudVersionName.startsWith("3")){
            DebugLogger.e(TAG,"flyme 3.x start register cloud versionName "+cloudVersionName);
            pushServiceIntent.setAction(PushConstants.REQUEST_REGISTRATION_INTENT);
            pushServiceIntent.setPackage("com.meizu.cloud");
            pushServiceIntent.putExtra(PushConstants.EXTRA_APPLICATION_PENDING_INTENT,PendingIntent.getBroadcast(context, 0, new Intent(), 0));
            pushServiceIntent.putExtra(PushConstants.EXTRA_SENDER, context.getPackageName());
        } else {
            DebugLogger.e(TAG,context.getPackageName()+" start register ");
            //正常逻辑
            pushServiceIntent.setClassName(context.getPackageName(),"com.meizu.cloud.pushsdk.pushservice.MzPushService");
            pushServiceIntent.putExtra(PushConstants.REGISTER_PACKAGE_NAME,context.getPackageName());
        }
        context.startService(pushServiceIntent);
    }

    @Deprecated
    public static void unRegister(Context context){
        String cloudVersionName = MzSystemUtils.getAppVersionName(context, "com.meizu.cloud");
        DebugLogger.e(TAG, context.getPackageName() + " start unRegister cloud versionName " + cloudVersionName);
        Intent pushServiceIntent = new Intent(PushConstants.MZ_PUSH_ON_STOP_PUSH_REGISTER);
        if("com.meizu.cloud".equals(MzSystemUtils.getMzPushServicePackageName(context))){
            pushServiceIntent.setClassName("com.meizu.cloud","com.meizu.cloud.pushsdk.pushservice.MzPushService");
            //兼容云服务低版本获取包名的方法
            pushServiceIntent.putExtra(PushConstants.UNREGISTER_PACKAGE_NAME,context.getPackageName());
        } else if(!TextUtils.isEmpty(cloudVersionName) && MzSystemUtils.compareVersion(cloudVersionName, "4.5.7")){
            //兼容5.0以下版本
            pushServiceIntent.setPackage("com.meizu.cloud");
            pushServiceIntent.putExtra(PushConstants.EXTRA_SENDER,context.getPackageName());
        } else if(!TextUtils.isEmpty(cloudVersionName) && cloudVersionName.startsWith("3")) {
            pushServiceIntent.setAction(PushConstants.REQUEST_UNREGISTRATION_INTENT);
            pushServiceIntent.setPackage("com.meizu.cloud");
            pushServiceIntent.putExtra(PushConstants.EXTRA_APPLICATION_PENDING_INTENT,PendingIntent.getBroadcast(context, 0, new Intent(), 0));
            pushServiceIntent.putExtra(PushConstants.EXTRA_SENDER, context.getPackageName());
        } else {
            DebugLogger.e(TAG,context.getPackageName()+" start unRegister ");
            pushServiceIntent.setClassName(context.getPackageName(),"com.meizu.cloud.pushsdk.pushservice.MzPushService");
            pushServiceIntent.putExtra(PushConstants.UNREGISTER_PACKAGE_NAME,context.getPackageName());
        }
        context.startService(pushServiceIntent);
    }

    /**
     * 根据应用包名获取pushId
     * @param context
     * @return 如果该包名没有注册，则默认返回为null
     * */
    public static String getPushId(Context context){
        int expireTime = PushPreferencesUtils.getPushIdExpireTime(context);
        if(System.currentTimeMillis()/1000 > expireTime){
            return null;
        } else {
            return PushPreferencesUtils.getPushId(context);
        }
    }


    /**
     * 检查通知栏和透传消息开关状态
     * @param appId
     *          push 平台申请的应用id
     * @param appKey
     *          push 平台申请的应用key
     * @param pushId
     *          注册成功后返回的pushid
     *
     *  结果会在你所实现的receiver的onCheckPush中返回
     * */
    public static void checkPush(Context context,String appId,String appKey,String pushId){
         PushPlatformManager.getInstance(context).checkPush(appId,appKey,pushId);
    }

    /**
     * @param appId
     *        push 平台申请的应用id
     * @param appKey
     *        push 平台申请的应用key
     * @param pushId
     *        注册成功后返回的pushid
     * @param pushType
     *        接收的消息类型，0:通知栏消息 1: 透传消息
     * @param switcher
     *        修改push类型开关状态
     * */
    public static void switchPush(Context context,String appId,String appKey,String pushId,int pushType,boolean switcher){
        PushPlatformManager.getInstance(context).switchPush(appId, appKey, pushId, pushType, switcher);

    }

    /**
     * @param context
     * @param appId
     *         push 平台申请的应用id
     * @param appKey
     *         push 平台申请的应用key
     * */
     public static void register(Context context,String appId,String appKey){
         DebugLogger.initDebugLogger(context);
         PushPlatformManager.getInstance(context).register(appId, appKey);
     }

    /**
     * @param context
     * @param appId
     *         push 平台申请的应用id
     * @param appKey
     *         push 平台申请的应用key
     * */
     public static void unRegister(Context context,String appId,String appKey){
         PushPlatformManager.getInstance(context).unRegister(appId, appKey);
     }


    /**
     * 标签订阅
     * @param context
     * @param appId
     *         push 平台申请的应用id
     * @param appKey
     *         push 平台申请的应用key
     * @param tags
     *         多个标签逗号隔离
     * **/
     public static void subScribeTags(Context context,String appId,String appKey,String pushId,String tags){
         PushPlatformManager.getInstance(context).subScribeTags(appId, appKey, pushId, tags);
     }

     /**
      * 取消标签订阅
      * @param context
      * @param appId
      *         push 平台申请的应用id
      * @param appKey
      *         push 平台申请的应用key
      * @param tags
      *         多个标签逗号隔离
      * */
     public static void unSubScribeTags(Context context, String appId, String appKey, String pushId,String tags){
         PushPlatformManager.getInstance(context).unSubScribeTags(appId, appKey, pushId, tags);
     }

    /**
     * 获取标签订阅列表
     * @param context
     * @param appId
     *         push 平台申请的应用id
     * @param appKey
     *         push 平台申请的应用key
     * **/
     public static void checkSubScribeTags(Context context,String appId,String appKey,String pushId){
         PushPlatformManager.getInstance(context).checkSubScribeTags(appId, appKey, pushId);
     }

    /**
     * 别名订阅
     * @param context
     * @param appId
     *         push 平台申请的应用id
     * @param appKey
     *         push 平台申请的应用key
     * @param pushId
     *         注册成功后返回的pushid
     * @param alias
     *         别名
     * **/
     public static void subScribeAlias(Context context,String appId,String appKey,String pushId,String alias){
         PushPlatformManager.getInstance(context).subScribeAlias(appId, appKey, pushId, alias);
     }

    /**
     * 取消别名订阅
     * @param context
     * @param appId
     *         push 平台申请的应用id
     * @param appKey
     *         push 平台申请的应用key
     * @param pushId
     *         注册成功后返回的pushid
     * @param alias
     *         别名
     * **/
     public static void unSubScribeAlias(Context context,String appId,String appKey,String pushId,String alias){
         PushPlatformManager.getInstance(context).unSubScribeAlias(appId, appKey, pushId, alias);
     }

    /**
     * 获取别名
     * @param context
     * @param appId
     *         push 平台申请的应用id
     * @param appKey
     *         push 平台申请的应用key
     * @param pushId
     *         注册成功后返回的pushid
     * **/
     public static void checkSubScribeAlias(Context context,String appId,String appKey,String pushId){
         PushPlatformManager.getInstance(context).checkSubScribeAlias(appId, appKey, pushId);
     }

     /**
      * 获取通知栏消息列表
      * @param context 
      * */
     public static void checkNotificationMessage(Context context){
         String cloudVersionName = MzSystemUtils.getAppVersionName(context, "com.meizu.cloud");
         DebugLogger.i(TAG, context.getPackageName() + " checkNotificationMessage cloudVersion_name " + cloudVersionName);
         if(!TextUtils.isEmpty(cloudVersionName) && cloudVersionName.startsWith("6")){
             Intent pushServiceIntent = new Intent(PushConstants.MZ_PUSH_ON_GET_NOTIFICATION_MESSAGE);
             pushServiceIntent.putExtra(PushConstants.EXTRA_GET_NOTIFICATION_PACKAGE_NAME,context.getPackageName());
             pushServiceIntent.setClassName("com.meizu.cloud","com.meizu.cloud.pushsdk.pushservice.MzPushService");
             context.startService(pushServiceIntent);
         }
     }

}
