package com.meizu.cloud.pushsdk.common.base;


import com.meizu.cloud.pushsdk.common.util.Logger;

import java.util.concurrent.atomic.AtomicInteger;

/**
 * Created by zbin on 2016/1/13 0013.
 */
public abstract class CountableWithConfig<T> {
    protected T mConfig;
    private AtomicInteger mCounter = new AtomicInteger(0);
    protected String mTag;

    public CountableWithConfig(String tag) {
        mTag = tag;
    }

    public final void init(T config) {
        synchronized (mCounter) {
            if(mCounter.incrementAndGet() == 1) {
                Logger.i(mTag, "call onInit");
                mConfig = config;
                onInit();
            }
        }
    }

    protected abstract void onInit();

    protected abstract void onDestroy();

    public final void destroy() {
        synchronized (mCounter) {
            if(mCounter.decrementAndGet() == 0) {
                Logger.i(mTag, "call onDestroy");
                onDestroy();
            }
        }
    }
}
