package com.meizu.cloud.pushsdk.common.base;

import android.text.TextUtils;
import android.util.Log;


import com.meizu.cloud.pushsdk.common.util.Logger;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;

/**
 * Created by zbin on 15-11-4.
 */
public class EncryptLogger implements Logger.Callback {
    private String mPath;
    private BufferedWriter mWriter;
    private EncryptBase64 mEncryptor;

    /**
     * 构造函数
     * @param dir app日志保存的目录
     */
    public EncryptLogger(String dir) {
        mPath = dir;
        mEncryptor = new EncryptBase64("lo");
    }

    private synchronized void open() throws IOException {
        String tag = "EncryptLogger";
        String fileName = "logs_v2.txt";
        String oldFileName = "logs_v2_old.txt";
        boolean append = true;
        if(!TextUtils.isEmpty(mPath)) {
            do {
                File logDir = new File(mPath);
                //创建目录
                if(!logDir.exists()) {
                    if(!logDir.mkdirs()) {
                        Log.e(tag, "create dir " + mPath + " failed!");
                        break;
                    }
                }
                //创建文件
                File logFile = new File(logDir, fileName);
                if(!logFile.exists()) {
                    if(!logFile.createNewFile()) {
                        Log.e(tag, "create new file " + fileName + " failed!");
                        break;
                    }
                }
                //检查是否超过单个文件大小限制
                if(logFile != null &&
                        logFile.length() >= 30 * 1024 * 1024) {
                    String parent = logFile.getParent();
                    File oldFile = new File(parent, oldFileName);
                    if(oldFile.exists()) {
                        if(oldFile.delete()) {
                            if(logFile.renameTo(new File(parent, oldFileName))) {
                                append = false;
                            }
                        }
                    } else {
                        if(logFile.renameTo(new File(parent, oldFileName))) {
                            append = false;
                        }
                    }
                }

                mWriter = new BufferedWriter(new FileWriter(logFile, append));
            } while (false);
        }
    }

    private synchronized void close(){
        if(mWriter != null) {
            try {
                mWriter.close();
            } catch (IOException e) {
                //ignore
            }
        }
    }

    @Override
    public void print(Level level, String tag, String msg) {
        try {
            open();
            if(mWriter != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(tag);
                sb.append("/");
                sb.append(level == Level.DEBUG ? "D" :
                        (level == Level.INFO ? "I" :
                                (level == Level.WARN ? "W" : "E")));
                sb.append(": ");
                sb.append(msg);
                mWriter.append(mEncryptor.encode(sb.toString().getBytes(Charset.forName("UTF-8"))));
                mWriter.append("\r\n");
                mWriter.flush();
            }
        } catch (Exception e) {
            //ignore
        } finally {
            close();
        }
    }
}
