package com.meizu.cloud.pushsdk.common.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.text.TextUtils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;

public class DeviceUtils {
    private static final String TAG = "DeviceUtils";
    private static String sMacAddr = "";
    private static String sDeviceId = "";


    public static boolean isPhone(){
        Reflector.Result<String> result = SystemProperties.get("ro.target.product");
        if(result.ok){
            if(!TextUtils.isEmpty(result.value)){
                Logger.i(TAG,"current product is "+result.value);
                return false;
            }
        }
        Logger.i(TAG,"current product is phone");
        return true;
    }

    public static String getDeviceType(){
        String deviceType = null;
        Reflector.Result<String> result = SystemProperties.get("ro.target.product");
        if(result.ok){
            if(!TextUtils.isEmpty(result.value)){
                Logger.i(TAG,"current product is "+result.value);
                deviceType = result.value;
            }
        }
        return deviceType;
    }

    /*
    *  获取设备唯一标识id：如果是手机，返回imei，如果是pad，使用 sn+mac
    */
    public static String getDeviceId(Context context) {
        if (TextUtils.isEmpty(sDeviceId)) {
            if (!isPhone()) {//非phone直接返回sn+mac；
                if (TextUtils.isEmpty(sDeviceId)) {
                    StringBuilder nonce = new StringBuilder();
                    String sn = Build.SERIAL;
                    Logger.i(TAG,"device serial "+sn);
                    if (!TextUtils.isEmpty(sn)) {
                        nonce.append(sn);
                    } else {
                        return null;
                    }
                    String mac = getMACAddress(context);
                    Logger.e(TAG,"mac address "+mac);
                    if (!TextUtils.isEmpty(mac)) {
                        mac = mac.replace(":", "");
                        mac = mac.toUpperCase();
                        nonce.append(mac);
                    } else {
                        return null;
                    }
                    sDeviceId = nonce.toString();
                }
            } else {//todo 如何区分手机和tv
                sDeviceId = Utility.getImei(context);
            }
        }
        return sDeviceId;
    }


    /*
    *  获取设备mac地址；
    */
    public static String getMACAddress(Context context) {
        if (!TextUtils.isEmpty(sMacAddr)) {
            return sMacAddr;
        }
        String address = null;
        if (android.os.Build.VERSION.SDK_INT >= 23) {//6.0上用wifiManager会返回无效mac： 02:00:00:00:00:00,   6.0以下用NetworkInfo在未联网时，会返回null，所以区分处理；
            ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
            if (null != cm) {
                NetworkInfo info = cm.getActiveNetworkInfo();
                if (info != null) {
                    if (info.getType() == ConnectivityManager.TYPE_WIFI) {
                        address = getMacAddressWithIfName("wlan0");
                    } else if (info.getType() == ConnectivityManager.TYPE_ETHERNET) {
                        address = getMacAddressWithIfName("eth0");
                    }
                } else {
                    address = getMacAddressWithIfName("wlan0");
                    if (TextUtils.isEmpty(address)) {
                        address = getMacAddressWithIfName("eth0");
                    }
                }
            }
        } else {
            WifiManager wifiManager = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);
            if (null != wifiManager) {
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                address = wifiInfo == null ? null : wifiInfo.getMacAddress();
            }
        }
        sMacAddr = address;
        return sMacAddr;
    }


    private static String getMacAddressWithIfName(String name) {
        String address = null;
        try {
            InputStream in = new FileInputStream("/sys/class/net/" + name + "/address");
            Scanner reader = new Scanner(in);
            if (reader.hasNextLine()) {
                address = reader.nextLine().trim();
            }
            in.close();
        } catch (FileNotFoundException e) {
            Logger.e(TAG, "getMacAddressWithIfName File not found Exception");
        } catch (IOException e) {
            Logger.e(TAG,"getMacAddressWithIfName IOException");
        }
        return address;
    }

}
