package com.meizu.cloud.pushsdk.common.util;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * Created by zhangbin on 16-3-28.
 */
public class ThreadPool {
    private static ExecutorService sExecutor;

    private static synchronized Executor create() {
        if(sExecutor == null) {
            sExecutor = new ThreadPoolExecutor(0, 5, 180, TimeUnit.SECONDS,
                    new ArrayBlockingQueue<Runnable>(100, true));
        }
        return sExecutor;
    }

    public static void execute(Task task) {
        create();
        try {
            sExecutor.execute(task);
        } catch (RejectedExecutionException e) {
            new Thread(task).start();
        }
    }

    public static Executor getExecutor() {
        return create();
    }

    public static abstract class Task implements Runnable {

        @Override
        public final void run() {
            doInBackground();
        }

        public abstract void doInBackground();
    }
}
