package com.meizu.cloud.pushsdk.handler;

import android.content.Intent;

/**
 * 消息管理接口,负责消息适配
 *
 */
public interface MessageHandler {


    /**
     * 匹配消息格式
     * * 处理消息
     * 1.应用透传消息（V2,V3,Cloud）
     * 2.push平台消息Json(V3版本消息,Cloud通知栏json)
     * 3.push平台Object（V2版本消息）
     *
     * 4.注册消息
     * 5.点击通知栏消息
     * 6.反注册消息
     * @param intent
     *       method 每个Intent都有一个method属性
     *       action
     *
     * @return boolean
     * */
    public boolean messageMatch(Intent intent);


    /**
     * send message
     * @return
     * */
    public boolean sendMessage(Intent intent);


    public int getProcessorType();

}
