package com.meizu.cloud.pushsdk.handler.impl;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.constants.PushConstants;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;
import com.meizu.cloud.pushsdk.util.UxIPUtils;

/**
 * 通道透传消息处理
 */
public class ThroughMessageHandler extends AbstractMessageHandler<MessageV3> {

    public ThroughMessageHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i(TAG, "start ThroughMessageHandler match");
        if(!canReceiveMessage(1,getPushServiceDefaultPackageName(intent))){
            return false;
        }
        if(PushConstants.MZ_PUSH_ON_MESSAGE_ACTION.equals(intent.getAction())){
            //V2 V3 高版本透传消息
            if(PushConstants.MZ_PUSH_MESSAGE_METHOD_ACTION_MESSAGE.equals(getIntentMethod(intent))){
                return true;
            }
            //cloudService 透传消息
            if(TextUtils.isEmpty(getIntentMethod(intent))){
                String cloudPushMessage = intent.getStringExtra(PushConstants.EXTRA_PUSH_MESSAGE);
                //1 通知栏消息格式
                if(!TextUtils.isEmpty(cloudPushMessage) && !isNotificationJson(cloudPushMessage)){
                    return true;
                }
            }
        }

        //C2DM 透传消息
        if(PushConstants.C2DM_INTENT.equals(intent.getAction())){
            return true;
        }

        return false;
    }

    @Override
    public int getProcessorType() {
        return MESSAGE_TYPE_THROUGH;
    }


    @Override
    protected MessageV3 getMessage(Intent intent) {
        MessageV3 messageV3 = new MessageV3();
        //process c2dm message
        if(PushConstants.C2DM_INTENT.equals(intent.getAction())){
            appLogicListener().onMessage(context(),intent);
            return null;
        }
        messageV3.setThroughMessage(intent.getStringExtra(PushConstants.EXTRA_PUSH_MESSAGE));
        messageV3.setTaskId(getTaskId(intent));
        messageV3.setDeviceId(getDeviceId(intent));
        messageV3.setSeqId(getSeqId(intent));
        messageV3.setPushTimestamp(getPushTimestamp(intent));
        messageV3.setUploadDataPackageName(getPushServiceDefaultPackageName(intent));
        return messageV3;
    }

    @Override
    protected void unsafeSend(MessageV3 message, PushNotification pushNotification) {
        if(appLogicListener() != null && message != null){
            if(!TextUtils.isEmpty(message.getThroughMessage())){
                appLogicListener().onMessage(context(),message.getThroughMessage());
            }
        }
    }


    @Override
    protected void onBeforeEvent(MessageV3 message) {
        if(message != null && !TextUtils.isEmpty(message.getDeviceId()) && !TextUtils.isEmpty(message.getTaskId())){
            UxIPUtils.onReceiveThroughMessage(context(), message.getUploadDataPackageName(), message.getDeviceId(), message.getTaskId(),message.getSeqId(),message.getPushTimestamp());
        }
    }

}
