package com.meizu.cloud.pushsdk.handler.impl.platform;

import android.content.Context;
import android.content.Intent;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.constants.PushConstants;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.impl.AbstractMessageHandler;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.platform.message.SubTagsStatus;

/**
 * Created by liaojinlong on 16-5-20.
 */
public class SubScribeTagsStatusHandler extends AbstractMessageHandler<SubTagsStatus>{
    public SubScribeTagsStatusHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    protected SubTagsStatus getMessage(Intent intent) {
        SubTagsStatus subTagsStatus = (SubTagsStatus) intent.getSerializableExtra(PushConstants.EXTRA_APP_PUSH_SUBTAGS_STATUS);
        return subTagsStatus;
    }

    @Override
    protected void unsafeSend(SubTagsStatus message, PushNotification pushNotification) {
        if(appLogicListener() != null && message != null){
            appLogicListener().onSubTagsStatus(context(),message);
        }
    }

    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i(TAG, "start SubScribeTagsStatusHandler match");
        return PushConstants.MZ_PUSH_ON_MESSAGE_ACTION.equals(intent.getAction())
                && PushConstants.MZ_PUSH_MESSAGE_METHOD_ACTION_SUBTAGS_STATUS.equals(getIntentMethod(intent));
    }

    @Override
    public int getProcessorType() {
        return MESSAGE_TYPE_PUSH_SUBTAGS_STATUS;
    }
}
