package com.meizu.cloud.pushsdk.notification;

import android.app.Notification;
import android.content.Context;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.util.MinSdkChecker;

/**
 * Standard Notification,disable ExpandableText
 * * general setting
 * * advanceSetting
 * * timeDisplaySetting
 *
 * * AppIcon Setting
 */
public class StandardNotificationV2 extends AbstractPushNotification {
    //private static final String TAG = "StandardNotification";
    public StandardNotificationV2(Context context, PushNotificationBuilder pushNotificationBuilder) {
        super(context, pushNotificationBuilder);
    }

    @Override
    protected void buildExpandableContent(Notification.Builder builder, MessageV3 messageV3) {
        if(MinSdkChecker.isSupportNotificationBuild()){
            Notification.BigTextStyle notiStyle = new Notification.BigTextStyle();
            notiStyle.setBigContentTitle(messageV3.getTitle());
            notiStyle.setSummaryText(messageV3.getContent());
            notiStyle.bigText(messageV3.getContent());
            builder.setStyle(notiStyle);
        }

    }
}
