package com.meizu.cloud.pushsdk.notification.android;

import android.app.Notification;
import android.content.Context;

import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.util.MinSdkChecker;

/**
 * Created by liaojinlong on 16-7-1.
 */
public class AndroidExpandableTextNotification extends AndroidStandardNotification{

    public AndroidExpandableTextNotification(Context context, PushNotificationBuilder pushNotificationBuilder) {
        super(context, pushNotificationBuilder);
    }

    @Override
    protected void buildExpandableContent(Notification.Builder builder, MessageV3 messageV3) {
        if(MinSdkChecker.isSupportNotificationBuild()){
            Notification.BigTextStyle notiStyle = new Notification.BigTextStyle();
            notiStyle.setBigContentTitle(messageV3.getTitle());
            notiStyle.setSummaryText(messageV3.getContent());
            notiStyle.bigText(messageV3.getmNotificationStyle().getExpandableText());
            builder.setStyle(notiStyle);
        }
    }
}
