package com.meizu.cloud.pushsdk.platform.api;

import android.content.Context;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.common.util.Utility;
import com.meizu.cloud.pushsdk.networking.AndroidNetworking;
import com.meizu.cloud.pushsdk.networking.interfaces.OkHttpResponseAndStringRequestListener;
import com.meizu.cloud.pushsdk.platform.SignUtils;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;


/**
 * Created by liaojinlong on 16-11-26.
 */
public class PushAPI {
    public static final String TAG = "PushAPI";

    public String API_SERVER = "https://api-push.meizu.com/garcia/api/client/";

    private String REGISTER_URL_PRIX = API_SERVER + "message/registerPush";
    private String UNREGISTER_URL_PRIX = API_SERVER +"message/unRegisterPush";
    private String UNREGISTER_URL_ADVANCE_PRIX = API_SERVER + "advance/unRegisterPush";
    private String CHECK_REGISTER_SWITCH_STATUS_URL_PRIX = API_SERVER +"message/getRegisterSwitch";
    private String CHANGE_REGISTER_SWITCH_STATUS_URL_PRIX = API_SERVER+"message/changeRegisterSwitch";
    private String SUBSCRIBE_TAGS_URL_PRIX = API_SERVER + "message/subscribeTags";
    private String UNSUBSCRIBE_TAGS_URL_PRIX = API_SERVER + "message/unSubscribeTags";
    private String CHECK_SUBSCRIBE_TAGS_URL_PRIX = API_SERVER + "message/getSubTags";
    private String SUBSCRIBE_ALIAS_URL_PRIX = API_SERVER + "message/subscribeAlias";
    private String UNSUBSCRIBE_ALIAS_URL_PRIX = API_SERVER + "message/unSubscribeAlias";
    private String CHECK_SUBSCRIBE_ALIAS_URL_PRIX = API_SERVER + "message/getSubAlias";


    public PushAPI(Context mContext){
        AndroidNetworking.enableLogging();
        if(Utility.isInternational() || Utility.isIndiaLocal()) {
            API_SERVER = "https://api-push.in.meizu.com/garcia/api/client/";
            REGISTER_URL_PRIX = API_SERVER + "message/registerPush";
            UNREGISTER_URL_PRIX = API_SERVER +"message/unRegisterPush";
            UNREGISTER_URL_ADVANCE_PRIX = API_SERVER + "advance/unRegisterPush";
            CHECK_REGISTER_SWITCH_STATUS_URL_PRIX = API_SERVER +"message/getRegisterSwitch";
            CHANGE_REGISTER_SWITCH_STATUS_URL_PRIX = API_SERVER+"message/changeRegisterSwitch";
            SUBSCRIBE_TAGS_URL_PRIX = API_SERVER + "message/subscribeTags";
            UNSUBSCRIBE_TAGS_URL_PRIX = API_SERVER + "message/unSubscribeTags";
            CHECK_SUBSCRIBE_TAGS_URL_PRIX = API_SERVER + "message/getSubTags";
            SUBSCRIBE_ALIAS_URL_PRIX = API_SERVER + "message/subscribeAlias";
            UNSUBSCRIBE_ALIAS_URL_PRIX = API_SERVER + "message/unSubscribeAlias";
            CHECK_SUBSCRIBE_ALIAS_URL_PRIX = API_SERVER + "message/getSubAlias";
        }
    }

    /**
     * 设备订阅
     * @param appId
     * @param appKey
     * @param deviceId
     * */
    public void register(String appId,String appKey,String deviceId,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId",appId);
        paramsMap.put("deviceId", deviceId);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "register post map " + requestMap);
        AndroidNetworking.post(REGISTER_URL_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    /**
     * push平台反注册
     * @param appId
     *            push 平台申请的id
     * @param appKey
     * @param deviceId
     *             设备唯一标志
     * */
    public void unRegister(String appId,String appKey,String deviceId,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId",appId);
        paramsMap.put("deviceId", deviceId);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "unregister post map " + requestMap);
        AndroidNetworking.get(UNREGISTER_URL_PRIX)
                .addQueryParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    /**
     * 高级反注册接口,用于应用卸载后的反注册
     * @param packageName
     * @param deviceId
     * */
    public void unRegister(String packageName,String deviceId,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("packageName", packageName);
        paramsMap.put("deviceId", deviceId);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, "4a2ca769d79f4856bb3bd982d30de790"));
        DebugLogger.i(TAG, "advance unregister post map " + requestMap);
        AndroidNetworking.post(UNREGISTER_URL_ADVANCE_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    /**
     * 获取push状态开关
     * */
    public void checkPush(String appId,String appKey,String pushId,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId",appId);
        paramsMap.put("pushId", pushId);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "checkPush post map " + requestMap);
        AndroidNetworking.get(CHECK_REGISTER_SWITCH_STATUS_URL_PRIX)
                .addQueryParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    /**
     * 修改push开关
     * */
    public void switchPush(String appId,String appKey,String pushId,int msgType,boolean switcher,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("msgType", String.valueOf(msgType));
        paramsMap.put("subSwitch", switcher ? "1" : "0");
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "swithPush post map " + requestMap);
        AndroidNetworking.post(CHANGE_REGISTER_SWITCH_STATUS_URL_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public void subScribeTags(String appId,String appKey,String pushId,String args,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("tags", args);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        AndroidNetworking.post(SUBSCRIBE_TAGS_URL_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public void unSubScribeTags(String appId,String appKey,String pushId,String args,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("tags", args);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        AndroidNetworking.post(UNSUBSCRIBE_TAGS_URL_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public void checkSubScribeTags(String appId,String appKey,String pushId,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        Map<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId",appId);
        paramsMap.put("pushId", pushId);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "checkPush post map " + requestMap);
        AndroidNetworking.get(CHECK_SUBSCRIBE_TAGS_URL_PRIX)
                .addQueryParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public void subScribeAlias(String appId,String appKey,String pushId,String alias,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId", appId);
        paramsMap.put("appKey", appKey);
        paramsMap.put("pushId", pushId);
        paramsMap.put("alias", alias);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        AndroidNetworking.post(SUBSCRIBE_ALIAS_URL_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public void unSubScribeAlias(String appId,String appKey,String pushId,String alias,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("alias", alias);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        AndroidNetworking.post(UNSUBSCRIBE_ALIAS_URL_PRIX)
                .addBodyParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public void checkSubScribeAlias(String appId,String appKey,String pushId,OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener){
        HashMap<String,String> paramsMap = new LinkedHashMap<>();
        paramsMap.put("appId",appId);
        paramsMap.put("pushId", pushId);
        HashMap<String,String> requestMap = new LinkedHashMap<>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "checkPush post map " + requestMap);
        AndroidNetworking.get(CHECK_SUBSCRIBE_ALIAS_URL_PRIX)
                .addQueryParameter(requestMap)
                .build()
                .getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }


}
