package com.meizu.cloud.pushsdk.util;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.provider.Settings;
import android.text.TextUtils;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.common.util.DeviceUtils;
import com.meizu.cloud.pushsdk.common.util.Utility;

import java.util.List;

/**
 * Created by liaojinlong on 15-6-11.
 */
public class MzSystemUtils {
    private static final String TAG = "MzSystemUtils";

    private static String getServicesByPackageName(Context context,String packageName) {
        PackageManager packageManager = context.getPackageManager();
        ServiceInfo[] serviceInfos = null;

        try {
            serviceInfos = packageManager.getPackageInfo(packageName, PackageManager.GET_SERVICES).services;
        } catch (PackageManager.NameNotFoundException var4) {
        }

        if(serviceInfos == null) {
            return null;
        } else {
            for(int i = 0; i < serviceInfos.length; ++i) {
                if("com.meizu.cloud.pushsdk.pushservice.MzPushService".equals(serviceInfos[i].name)) {
                    return serviceInfos[i].processName;
                }
            }
            return null;
        }
    }


    /**
     * 获取首次启动MzPushService的包名
     * MzPushService只会由首次启动自身的应用启动,该应用的包名既是各个应用所需要的包名
     * 如果应用中没有一个启动mzPushService,策略选择那个service进行启动
     * @param context
     * */
    public static String getMzPushServicePackageName(Context context){
        String packageName = context.getPackageName();
        try {
            String mzPushserviceProcessName = getServicesByPackageName(context,"com.meizu.cloud");
            if(!TextUtils.isEmpty(mzPushserviceProcessName) && mzPushserviceProcessName.contains("mzservice_v1")){
                packageName = "com.meizu.cloud";
                return packageName;
            }
        } catch (Exception var8) {
            var8.printStackTrace();
        }
        DebugLogger.i("SystemUtils", "startservice package name " + packageName);
        return packageName;
    }


    /**
     * 返回当前程序版本名
     */
    public static String getAppVersionName(Context context,String packageName) {
        String versionName = "";
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            versionName = pi.versionName;
            if (versionName == null || versionName.length() <= 0) {
                return "";
            }
        } catch (Exception e) {
            DebugLogger.e("VersionInfo", "Exception message " + e.getMessage());
            return "";
        }
        return versionName;
    }

    /**
     * @param version1
     * @param version2
     * @return boolean
     */
    public static boolean compareVersion(String version1, String version2){
        String[] versionArray1 = version1.split("\\.");
        String[] versionArray2 = version2.split("\\.");
        int idx = 0;
        int minLength = Math.min(versionArray1.length, versionArray2.length);
        int diff = 0;
        while (idx < minLength
                && (diff = versionArray1[idx].length() - versionArray2[idx].length()) == 0
                && (diff = versionArray1[idx].compareTo(versionArray2[idx])) == 0) {
            ++idx;
        }
        //如果已经分出大小，则直接返回，如果未分出大小，则再比较位数，有子版本的为大
        diff = (diff != 0) ? diff : versionArray1.length - versionArray2.length;
        return diff >= 0 ? true : false;
    }


    public static String findReceiver(Context paramContext, String action, String packageName){
        if ((TextUtils.isEmpty(action)) || (TextUtils.isEmpty(packageName))){
            return null;
        }
        List localList;
        Intent localIntent = new Intent(action);
        localIntent.setPackage(packageName);
        localList = paramContext.getPackageManager().queryBroadcastReceivers(localIntent, 0);
        if(localList != null && localList.size() > 0){
            return ((ResolveInfo)localList.get(0)).activityInfo.name;
        }
        return null;
    }

    /**
     * get deviceId
     * @param context
     * */
    public static String getDeviceId(Context context){
        String deviceId = DeviceUtils.getDeviceId(context);
        return  deviceId;
    }

    public static boolean isBrandMeizu(){
        return Utility.isBrandMeizu();
    }


}
