package com.meizu.cloud.pushsdk.util;

import android.content.Context;
import android.content.SharedPreferences;

import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.constants.PushConstants;

/**
 * Created by liaojinlong on 15-4-22.
 */
public class PushPreferencesUtils {

    public static final String MZ_PUSH_PREFERENCE = "mz_push_preference";
    private static final String MZ_PUSH_PREFIX_NOTIFICATION_ID = ".notification_id";
    private static final String MZ_PUSH_PREFIX_PUSH_TASK_ID = ".notification_push_task_id";
    private static final String MZ_PUSH_PREFIX_MESSAGE_SEQ = ".message_seq";
    /**
     * 获取执行name的preference
     * @param context
     * @param name
     * **/
    private static SharedPreferences getSharePerferenceByName(Context context, String name){
        //http://zmywly8866.github.io/2015/09/09/sharedpreferences-in-multiprocess.html
        SharedPreferences sharedPreferences = context.getSharedPreferences(name,Context.MODE_MULTI_PROCESS);
        return sharedPreferences;
    }

    /**
     * 保存String类型的数据
     * @param context
     * @param preferenceName
     * @param key
     * @param value
     *
     * */
    public static void putStringByKey(Context context,String preferenceName,String key,String value){
        SharedPreferences sharedPreferences = getSharePerferenceByName(context, preferenceName);
        sharedPreferences.edit().putString(key,value).commit();
    }

    public static String getStringBykey(Context context,String preferenceName,String key){
        return getSharePerferenceByName(context,preferenceName).getString(key,null);
    }

    public static void putIntBykey(Context context,String preferenceName,String key,int value){
        SharedPreferences sharedPreferences = getSharePerferenceByName(context, preferenceName);
        sharedPreferences.edit().putInt(key, value).commit();
    }

    public static int getIntBykey(Context context,String preferenceName,String key){
        return getSharePerferenceByName(context,preferenceName).getInt(key, 0);
    }

    public static void putBooleanByKey(Context context,String preferenceName,String key,boolean value){
        SharedPreferences sharedPreferences = getSharePerferenceByName(context,preferenceName);
        sharedPreferences.edit().putBoolean(key, value).commit();
    }

    public static boolean getBooleanByKey(Context context,String preferenceName,String key){
        return getSharePerferenceByName(context,preferenceName).getBoolean(key,true);
    }


    /**
     * get Default pushId
     * */
    public static String getPushId(Context context){
        return getStringBykey(context, PushConstants.PUSH_ID_PREFERENCE_NAME, PushConstants.KEY_PUSH_ID);
    }

    /**
     * put register pushId
     * */
    public static void putPushId(Context context,String pushId){
        putStringByKey(context, PushConstants.PUSH_ID_PREFERENCE_NAME, PushConstants.KEY_PUSH_ID, pushId);
    }

    /**
     * 缓存pushid过期时间
     * */
    public static void putPushIdExpireTime(Context context,int expireTime){
        putIntBykey(context, PushConstants.PUSH_ID_PREFERENCE_NAME, PushConstants.KEY_PUSH_ID_EXPIRE_TIME, expireTime);
    }

    /**
     * 获取pushid过期时间
     * */
    public static int getPushIdExpireTime(Context context){
        return getIntBykey(context,PushConstants.PUSH_ID_PREFERENCE_NAME,PushConstants.KEY_PUSH_ID_EXPIRE_TIME);
    }

    /**
     * get deviceId
     * */
    public static String getDeviceId(Context context){
        return getSharePerferenceByName(context,MZ_PUSH_PREFERENCE).getString(PushConstants.MZ_PUSH_MESSAGE_STATISTICS_IMEI_KEY, null);
    }

    public static void putDeviceId(Context context,String deviceId){
        putStringByKey(context,MZ_PUSH_PREFERENCE,PushConstants.MZ_PUSH_MESSAGE_STATISTICS_IMEI_KEY,deviceId);
    }
    /**
     * isDiscard消息notification存储
     * */
    public static void putDiscardNotificationIdByPackageName(Context context,String pkg,int notificationId){
        putIntBykey(context, MZ_PUSH_PREFERENCE, pkg + MZ_PUSH_PREFIX_NOTIFICATION_ID, notificationId);
    }

    public static int getDiscardNotificationId(Context context,String pkg){
        return getSharePerferenceByName(context,MZ_PUSH_PREFERENCE).getInt(pkg+MZ_PUSH_PREFIX_NOTIFICATION_ID,0);
    }

    public static void putDiscardNotificationTaskId(Context context,String pkg,int taskId){
        putIntBykey(context, MZ_PUSH_PREFERENCE, pkg + MZ_PUSH_PREFIX_PUSH_TASK_ID, taskId);
    }

    public static int getDiscardNotificationTaskId(Context context,String pkg){
        return getSharePerferenceByName(context,MZ_PUSH_PREFERENCE).getInt(pkg+MZ_PUSH_PREFIX_PUSH_TASK_ID,0);
    }

    /**
     * 设置通知栏开关状态
     * @param context
     * @param desPackageName
     *               目标开关应用
     * @param switcher
     *               开关状态
     * */
    public static void setNotificationMessageSwitchStatus(Context context,String desPackageName,boolean switcher){
        PushPreferencesUtils.putBooleanByKey(context, PushPreferencesUtils.MZ_PUSH_PREFERENCE, PushConstants.SWITCH_NOTIFICATION_MESSAGE+"_"+desPackageName, switcher);
    }

    /**
     * 获取当前通知栏消息的开关状态
     * */
    public static boolean getNotificationMessageSwitchStatus(Context context,String desPackageName){
        return PushPreferencesUtils.getBooleanByKey(context,PushPreferencesUtils.MZ_PUSH_PREFERENCE,PushConstants.SWITCH_NOTIFICATION_MESSAGE+"_"+desPackageName);
    }

    /**
     * 设置透传消息开关状态
     * @param context
     * @param desPackageName
     *                目标开关应用
     * @param switcher
     *                开关状态
     * */
    public static void setThroughMessageSwitchStatus(Context context,String desPackageName,boolean switcher){
        PushPreferencesUtils.putBooleanByKey(context,PushPreferencesUtils.MZ_PUSH_PREFERENCE,PushConstants.SWITCH_THROUGH_MESSAGE+"_"+desPackageName,switcher);
    }

    /**
     * 获取当前透传消息开关状态
     * */
    public static boolean getThroughMessageSwitchStatus(Context context,String desPackageName){
        return PushPreferencesUtils.getBooleanByKey(context, PushPreferencesUtils.MZ_PUSH_PREFERENCE, PushConstants.SWITCH_THROUGH_MESSAGE+"_"+desPackageName);
    }

    /**
     * 根据包名设置当前消息的序列号
     * @param packageName
     * */
    public static void putMessageSeq(Context context,String packageName,int messageSeq){
        putIntBykey(context,MZ_PUSH_PREFERENCE,packageName+MZ_PUSH_PREFIX_MESSAGE_SEQ,messageSeq);
    }

    /**
     * 获取当前消息序列号
     * @param context
     * @param packageName
     *                包名
     * */
    public static int getMessageSeqInCrease(Context context,String packageName){
        int messageSeq = getIntBykey(context,MZ_PUSH_PREFERENCE,packageName+MZ_PUSH_PREFIX_MESSAGE_SEQ);
        putMessageSeq(context,packageName,++messageSeq);
        DebugLogger.e(MZ_PUSH_PREFERENCE,"current messageSeq "+messageSeq);
        return messageSeq;
    }


}
