/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk;

import android.content.Context;
import android.content.Intent;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.PushMessageProxy;
import com.meizu.cloud.pushsdk.common.base.WorkReceiver;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.platform.message.PushSwitchStatus;
import com.meizu.cloud.pushsdk.platform.message.RegisterStatus;
import com.meizu.cloud.pushsdk.platform.message.SubAliasStatus;
import com.meizu.cloud.pushsdk.platform.message.SubTagsStatus;
import com.meizu.cloud.pushsdk.platform.message.UnRegisterStatus;
import com.meizu.cloud.pushsdk.util.UxIPUtils;

public abstract class MzPushMessageReceiver
extends WorkReceiver {
    public static final String TAG = "MzPushMessageReceiver";

    @Override
    public void onReceive(Context context, Intent intent) {
        try {
            super.onReceive(context, intent);
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "Event core error " + e.getMessage());
            UxIPUtils.onRecordMessageFlow(context, context.getPackageName(), null, null, "3.3.170123", "MzPushMessageReceiver " + e.getMessage(), 3000);
        }
    }

    @Override
    public void onHandleIntent(Context context, Intent intent) {
        PushMessageProxy.with(context).receiverListener(TAG, new AbstractAppLogicListener(){

            @Override
            public void onRegister(Context context, String pushId) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onRegister " + pushId);
                MzPushMessageReceiver.this.onRegister(context, pushId);
            }

            @Override
            public void onMessage(Context context, String message) {
                MzPushMessageReceiver.this.onMessage(context, message);
                DebugLogger.i(MzPushMessageReceiver.TAG, "recive message " + message);
            }

            @Override
            public void onUnRegister(Context context, boolean success) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onUnRegister " + success);
                MzPushMessageReceiver.this.onUnRegister(context, success);
            }

            @Override
            public void onMessage(Context context, Intent intent) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onMessage Flyme3 " + intent);
                MzPushMessageReceiver.this.onMessage(context, intent);
            }

            @Override
            public void onUpdateNotificationBuilder(PushNotificationBuilder pushNotificationBuilder) {
                MzPushMessageReceiver.this.onUpdateNotificationBuilder(pushNotificationBuilder);
            }

            @Override
            public void onPushStatus(Context context, PushSwitchStatus pushSwitchStatus) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onPushStatus " + pushSwitchStatus);
                MzPushMessageReceiver.this.onPushStatus(context, pushSwitchStatus);
            }

            @Override
            public void onRegisterStatus(Context context, RegisterStatus registerStatus) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onRegisterStatus " + registerStatus);
                MzPushMessageReceiver.this.onRegisterStatus(context, registerStatus);
            }

            @Override
            public void onUnRegisterStatus(Context context, UnRegisterStatus unRegisterStatus) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onUnRegisterStatus " + unRegisterStatus);
                MzPushMessageReceiver.this.onUnRegisterStatus(context, unRegisterStatus);
            }

            @Override
            public void onSubTagsStatus(Context context, SubTagsStatus subTagsStatus) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onSubTagsStatus " + subTagsStatus);
                MzPushMessageReceiver.this.onSubTagsStatus(context, subTagsStatus);
            }

            @Override
            public void onSubAliasStatus(Context context, SubAliasStatus subAliasStatus) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onSubAliasStatus " + subAliasStatus);
                MzPushMessageReceiver.this.onSubAliasStatus(context, subAliasStatus);
            }

            @Override
            public void onNotificationClicked(Context context, String title, String content, String selfDefineContentString) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onNotificationClicked title " + title + "content " + content + " selfDefineContentString " + selfDefineContentString);
                MzPushMessageReceiver.this.onNotificationClicked(context, title, content, selfDefineContentString);
            }

            @Override
            public void onNotificationArrived(Context context, String title, String content, String selfDefineContentString) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onNotificationArrived title " + title + "content " + content + " selfDefineContentString " + selfDefineContentString);
                MzPushMessageReceiver.this.onNotificationArrived(context, title, content, selfDefineContentString);
            }

            @Override
            public void onNotificationDeleted(Context context, String title, String content, String selfDefineContentString) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onNotificationDeleted title " + title + "content " + content + " selfDefineContentString " + selfDefineContentString);
                MzPushMessageReceiver.this.onNotificationDeleted(context, title, content, selfDefineContentString);
            }

            @Override
            public void onNotifyMessageArrived(Context context, String message) {
                DebugLogger.i(MzPushMessageReceiver.TAG, "onNotifyMessageArrived " + message);
                MzPushMessageReceiver.this.onNotifyMessageArrived(context, message);
            }
        }).processMessage(intent);
    }

    @Deprecated
    public abstract void onRegister(Context var1, String var2);

    public abstract void onMessage(Context var1, String var2);

    public void onMessage(Context context, Intent intent) {
    }

    @Deprecated
    public abstract void onUnRegister(Context var1, boolean var2);

    public void onUpdateNotificationBuilder(PushNotificationBuilder pushNotificationBuilder) {
    }

    public void onNotificationClicked(Context context, String title, String content, String selfDefineContentString) {
    }

    public void onNotificationArrived(Context context, String title, String content, String selfDefineContentString) {
    }

    public void onNotificationDeleted(Context context, String title, String content, String selfDefineContentString) {
    }

    public void onNotifyMessageArrived(Context context, String message) {
    }

    public abstract void onPushStatus(Context var1, PushSwitchStatus var2);

    public abstract void onRegisterStatus(Context var1, RegisterStatus var2);

    public abstract void onUnRegisterStatus(Context var1, UnRegisterStatus var2);

    public abstract void onSubTagsStatus(Context var1, SubTagsStatus var2);

    public abstract void onSubAliasStatus(Context var1, SubAliasStatus var2);
}

