/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.util.UxIPUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;

public class NotificationService
extends IntentService {
    private static final String TAG = "NotificationService";

    public NotificationService(String name) {
        super(name);
    }

    public NotificationService() {
        super(TAG);
    }

    public void onDestroy() {
        DebugLogger.i(TAG, "NotificationService destroy");
        super.onDestroy();
    }

    protected void onHandleIntent(Intent intent) {
        try {
            if (intent != null) {
                DebugLogger.i(TAG, "onHandleIntentaction " + intent.getAction());
                String commandType = intent.getStringExtra("command_type");
                DebugLogger.d(TAG, "-- command_type -- " + commandType);
                if (!TextUtils.isEmpty((CharSequence)commandType) && commandType.equals("reflect_receiver")) {
                    this.reflectReceiver(intent);
                }
            }
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "onHandleIntent error " + e.getMessage());
        }
    }

    public boolean onUnbind(Intent intent) {
        return super.onUnbind(intent);
    }

    public String getReceiver(String var1, String var2) {
        if (!TextUtils.isEmpty((CharSequence)var1) && !TextUtils.isEmpty((CharSequence)var2)) {
            String var3 = null;
            Intent var5 = new Intent(var2);
            var5.setPackage(var1);
            PackageManager var6 = this.getPackageManager();
            List var4 = var6.queryBroadcastReceivers(var5, 0);
            if (var4 != null && var4.size() > 0) {
                var3 = ((ResolveInfo)var4.get((int)0)).activityInfo.name;
            }
            return var3;
        }
        return null;
    }

    public void reflectReceiver(Intent intent) {
        String receiver = this.getReceiver(this.getPackageName(), intent.getAction());
        if (TextUtils.isEmpty((CharSequence)receiver)) {
            UxIPUtils.notificationEvent((Context)this, intent, "reflectReceiver sendbroadcast", 2005);
            DebugLogger.i(TAG, " reflectReceiver error: receiver for: " + intent.getAction() + " not found, package: " + this.getPackageName());
            intent.setPackage(this.getPackageName());
            this.sendBroadcast(intent);
        } else {
            try {
                UxIPUtils.notificationEvent((Context)this, intent, "reflectReceiver startservice", 2003);
                Class<?> receiverClass = Class.forName(receiver);
                Constructor<?> receiverClassConstructor = receiverClass.getConstructor(null);
                Object newInstance = receiverClassConstructor.newInstance(null);
                Class[] var7 = new Class[]{Context.class, Intent.class};
                Method onReceive = receiverClass.getMethod("onReceive", var7);
                intent.setClassName(this.getPackageName(), receiver);
                Object[] params = new Object[]{this.getApplicationContext(), intent};
                onReceive.invoke(newInstance, params);
            }
            catch (Exception var11) {
                DebugLogger.i(TAG, "reflect e: " + var11);
                UxIPUtils.notificationEvent((Context)this, intent, var11.getMessage(), 2004);
            }
        }
    }
}

