/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk;

import android.content.Context;
import android.content.Intent;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.MessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.MessageV2Handler;
import com.meizu.cloud.pushsdk.handler.impl.MessageV3Handler;
import com.meizu.cloud.pushsdk.handler.impl.RegisterMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.ThroughMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.UnRegisterMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.notification.NotificationClickMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.notification.NotificationDeleteMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.platform.PushSwitchStatusHandler;
import com.meizu.cloud.pushsdk.handler.impl.platform.ReceiveNotifyMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.platform.RegisterStatusHandler;
import com.meizu.cloud.pushsdk.handler.impl.platform.SubScribeAliasStatusHandler;
import com.meizu.cloud.pushsdk.handler.impl.platform.SubScribeTagsStatusHandler;
import com.meizu.cloud.pushsdk.handler.impl.platform.UnRegisterStatusHandler;
import com.meizu.cloud.pushsdk.handler.impl.schedule.ScheduleNotificationHandler;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.platform.message.PushSwitchStatus;
import com.meizu.cloud.pushsdk.platform.message.RegisterStatus;
import com.meizu.cloud.pushsdk.platform.message.SubAliasStatus;
import com.meizu.cloud.pushsdk.platform.message.SubTagsStatus;
import com.meizu.cloud.pushsdk.platform.message.UnRegisterStatus;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PushMessageProxy {
    private static final String TAG = "PushMessageProxy";
    private Context context;
    private Map<Integer, MessageHandler> managerHashMap = new HashMap<Integer, MessageHandler>();
    static volatile PushMessageProxy singleton = null;
    private Map<String, AbstractAppLogicListener> messageListenerMap = null;

    public PushMessageProxy(Context context) {
        this(context, null);
    }

    public PushMessageProxy(Context context, List<MessageHandler> messageManagerList) {
        this(context, messageManagerList, null);
    }

    public PushMessageProxy(Context context, List<MessageHandler> messageManagerList, AbstractAppLogicListener receiverLisener) {
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null.");
        }
        this.context = context.getApplicationContext();
        this.messageListenerMap = new HashMap<String, AbstractAppLogicListener>();
        DefaultPushMessageListener abstractAppLogicListener = new DefaultPushMessageListener();
        if (messageManagerList == null) {
            this.addHandler(new MessageV3Handler(context, abstractAppLogicListener));
            this.addHandler(new MessageV2Handler(context, abstractAppLogicListener));
            this.addHandler(new ThroughMessageHandler(context, abstractAppLogicListener));
            this.addHandler(new NotificationClickMessageHandler(context, abstractAppLogicListener));
            this.addHandler(new RegisterMessageHandler(context, abstractAppLogicListener));
            this.addHandler(new UnRegisterMessageHandler(context, abstractAppLogicListener));
            this.addHandler(new NotificationDeleteMessageHandler(context, abstractAppLogicListener));
            this.addHandler(new PushSwitchStatusHandler(context, abstractAppLogicListener));
            this.addHandler(new RegisterStatusHandler(context, abstractAppLogicListener));
            this.addHandler(new UnRegisterStatusHandler(context, abstractAppLogicListener));
            this.addHandler(new SubScribeAliasStatusHandler(context, abstractAppLogicListener));
            this.addHandler(new SubScribeTagsStatusHandler(context, abstractAppLogicListener));
            this.addHandler(new ScheduleNotificationHandler(context, abstractAppLogicListener));
            this.addHandler(new ReceiveNotifyMessageHandler(context, abstractAppLogicListener));
        } else {
            this.addHandler(messageManagerList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PushMessageProxy with(Context context) {
        if (singleton != null) return singleton;
        Class<PushMessageProxy> clazz = PushMessageProxy.class;
        synchronized (PushMessageProxy.class) {
            if (singleton != null) return singleton;
            DebugLogger.i(TAG, "PushMessageProxy init");
            singleton = new PushMessageProxy(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public PushMessageProxy receiverListener(String tag, AbstractAppLogicListener abstractAppLogicListener) {
        this.messageListenerMap.put(tag, abstractAppLogicListener);
        return this;
    }

    public PushMessageProxy unReceiverListener(String tag) {
        this.messageListenerMap.put(tag, null);
        return this;
    }

    public PushMessageProxy addHandler(MessageHandler messageManager) {
        this.managerHashMap.put(messageManager.getProcessorType(), messageManager);
        return this;
    }

    public PushMessageProxy addHandler(List<MessageHandler> messageManagerList) {
        if (messageManagerList == null) {
            throw new IllegalArgumentException("messageManagerList must not be null.");
        }
        for (MessageHandler messageManager : messageManagerList) {
            this.addHandler(messageManager);
        }
        return this;
    }

    public void processMessage(Intent intent) {
        DebugLogger.e(TAG, "is onMainThread " + this.isOnMainThread());
        try {
            String method = intent.getStringExtra("method");
            DebugLogger.i(TAG, "receive action " + intent.getAction() + " method " + method);
            if (intent != null) {
                Map.Entry<Integer, MessageHandler> iterator;
                MessageHandler messageManager;
                boolean mathResult;
                Iterator<Map.Entry<Integer, MessageHandler>> i$ = this.managerHashMap.entrySet().iterator();
                while (i$.hasNext() && !(mathResult = (messageManager = (iterator = i$.next()).getValue()).sendMessage(intent))) {
                }
            }
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "processMessage error " + e.getMessage());
        }
    }

    protected boolean isOnMainThread() {
        return Thread.currentThread() == this.context.getMainLooper().getThread();
    }

    public class DefaultPushMessageListener
    extends AbstractAppLogicListener {
        @Override
        public void onMessage(Context context, Intent intent) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onMessage(context, intent);
            }
        }

        @Override
        public void onRegister(Context context, String pushId) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onRegister(context, pushId);
            }
        }

        @Override
        public void onMessage(Context context, String message) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onMessage(context, message);
            }
        }

        @Override
        public void onUnRegister(Context context, boolean success) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onUnRegister(context, success);
            }
        }

        @Override
        public void onUpdateNotificationBuilder(PushNotificationBuilder pushNotificationBuilder) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onUpdateNotificationBuilder(pushNotificationBuilder);
            }
        }

        @Override
        public void onPushStatus(Context context, PushSwitchStatus pushSwitchStatus) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onPushStatus(context, pushSwitchStatus);
            }
        }

        @Override
        public void onRegisterStatus(Context context, RegisterStatus registerStatus) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onRegisterStatus(context, registerStatus);
            }
        }

        @Override
        public void onUnRegisterStatus(Context context, UnRegisterStatus unRegisterStatus) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onUnRegisterStatus(context, unRegisterStatus);
            }
        }

        @Override
        public void onSubTagsStatus(Context context, SubTagsStatus subTagsStatus) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onSubTagsStatus(context, subTagsStatus);
            }
        }

        @Override
        public void onSubAliasStatus(Context context, SubAliasStatus subAliasStatus) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onSubAliasStatus(context, subAliasStatus);
            }
        }

        @Override
        public void onNotificationClicked(Context context, String title, String content, String selfDefineContentString) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onNotificationClicked(context, title, content, selfDefineContentString);
            }
        }

        @Override
        public void onNotificationArrived(Context context, String title, String content, String selfDefineContentString) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onNotificationArrived(context, title, content, selfDefineContentString);
            }
        }

        @Override
        public void onNotificationDeleted(Context context, String title, String content, String selfDefineContentString) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onNotificationDeleted(context, title, content, selfDefineContentString);
            }
        }

        @Override
        public void onNotifyMessageArrived(Context context, String message) {
            for (Map.Entry entry : PushMessageProxy.this.messageListenerMap.entrySet()) {
                AbstractAppLogicListener abstractAppLogicListener = (AbstractAppLogicListener)entry.getValue();
                if (abstractAppLogicListener == null) continue;
                abstractAppLogicListener.onNotifyMessageArrived(context, message);
            }
        }
    }
}

