/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.common.base;

import com.meizu.cloud.pushsdk.common.util.Logger;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class CountableWithConfig<T> {
    protected T mConfig;
    private AtomicInteger mCounter = new AtomicInteger(0);
    protected String mTag;

    public CountableWithConfig(String tag) {
        this.mTag = tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(T config) {
        AtomicInteger atomicInteger = this.mCounter;
        synchronized (atomicInteger) {
            if (this.mCounter.incrementAndGet() == 1) {
                Logger.i(this.mTag, "call onInit");
                this.mConfig = config;
                this.onInit();
            }
        }
    }

    protected abstract void onInit();

    protected abstract void onDestroy();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        AtomicInteger atomicInteger = this.mCounter;
        synchronized (atomicInteger) {
            if (this.mCounter.decrementAndGet() == 0) {
                Logger.i(this.mTag, "call onDestroy");
                this.onDestroy();
            }
        }
    }
}

