/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.common.base;

import android.text.TextUtils;
import android.util.Log;
import com.meizu.cloud.pushsdk.common.base.EncryptBase64;
import com.meizu.cloud.pushsdk.common.util.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;

public class EncryptLogger
implements Logger.Callback {
    private String mPath;
    private BufferedWriter mWriter;
    private EncryptBase64 mEncryptor;

    public EncryptLogger(String dir) {
        this.mPath = dir;
        this.mEncryptor = new EncryptBase64("lo");
    }

    private synchronized void open() throws IOException {
        String tag = "EncryptLogger";
        String fileName = "logs_v2.txt";
        String oldFileName = "logs_v2_old.txt";
        boolean append = true;
        if (!TextUtils.isEmpty((CharSequence)this.mPath)) {
            File logDir = new File(this.mPath);
            if (!logDir.exists() && !logDir.mkdirs()) {
                Log.e((String)tag, (String)("create dir " + this.mPath + " failed!"));
            } else {
                File logFile = new File(logDir, fileName);
                if (!logFile.exists() && !logFile.createNewFile()) {
                    Log.e((String)tag, (String)("create new file " + fileName + " failed!"));
                } else {
                    if (logFile != null && logFile.length() >= 0x1E00000L) {
                        String parent = logFile.getParent();
                        File oldFile = new File(parent, oldFileName);
                        if (oldFile.exists()) {
                            if (oldFile.delete() && logFile.renameTo(new File(parent, oldFileName))) {
                                append = false;
                            }
                        } else if (logFile.renameTo(new File(parent, oldFileName))) {
                            append = false;
                        }
                    }
                    this.mWriter = new BufferedWriter(new FileWriter(logFile, append));
                }
            }
        }
    }

    private synchronized void close() {
        if (this.mWriter != null) {
            try {
                this.mWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Logger.Callback.Level level, String tag, String msg) {
        try {
            this.open();
            if (this.mWriter != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(tag);
                sb.append("/");
                sb.append(level == Logger.Callback.Level.DEBUG ? "D" : (level == Logger.Callback.Level.INFO ? "I" : (level == Logger.Callback.Level.WARN ? "W" : "E")));
                sb.append(": ");
                sb.append(msg);
                this.mWriter.append(this.mEncryptor.encode(sb.toString().getBytes(Charset.forName("UTF-8"))));
                this.mWriter.append("\r\n");
                this.mWriter.flush();
            }
        }
        catch (Exception e) {
        }
        finally {
            this.close();
        }
    }
}

