/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.common.event;

public abstract class Event<T> {
    protected T mData;
    private String mEventName;
    private long mDelay;
    private boolean mSticky;

    public Event(String name) {
        this.mEventName = name;
        this.mDelay = 0L;
        this.mSticky = true;
    }

    public abstract int getId();

    public <T> T getData() {
        try {
            return this.mData;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Event setData(T data) {
        this.mData = data;
        return this;
    }

    public long getDelay() {
        return this.mDelay;
    }

    public Event setDelay(long delay) {
        this.mDelay = delay;
        return this;
    }

    public boolean isSticky() {
        return this.mSticky;
    }

    public Event setSticky(boolean sticky) {
        this.mSticky = sticky;
        return this;
    }

    public String toString() {
        return "Event{ID='" + this.mEventName + '\'' + ", mData=" + this.mData + '}';
    }

    protected static class Generator {
        private static int sOffset = 0;

        protected Generator() {
        }

        public static synchronized int generate() {
            return ++sOffset;
        }
    }
}

