/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.common.event;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.meizu.cloud.pushsdk.common.base.CountableWithConfig;
import com.meizu.cloud.pushsdk.common.event.Event;
import com.meizu.cloud.pushsdk.common.event.Listener;
import com.meizu.cloud.pushsdk.common.event.Serviceable;
import com.meizu.cloud.pushsdk.common.util.Logger;
import com.meizu.cloud.pushsdk.common.util.Utility;
import java.util.ArrayList;
import java.util.HashMap;

public class EventCore
extends CountableWithConfig<Context> {
    private static EventCore sInstance;
    private HandlerThread mHandlerThread;
    private Handler mHandler;
    private HashMap<Integer, ArrayList<Listener>> mListenerMap = new HashMap();
    private HashMap<Integer, Event> mStickyEventMap = new HashMap();
    private ArrayList<Serviceable> mServices = new ArrayList();

    private EventCore() {
        super("EventCore");
    }

    public static synchronized EventCore get() {
        if (sInstance == null) {
            sInstance = new EventCore();
        }
        return sInstance;
    }

    public Looper getLooper() {
        return this.mHandler.getLooper();
    }

    public Context getContext() {
        return (Context)this.mConfig;
    }

    public EventCore post(Runnable task) {
        this.mHandler.post(task);
        return this;
    }

    public EventCore postDelayed(Runnable task, long delayMillis) {
        this.mHandler.postDelayed(task, delayMillis);
        return this;
    }

    public EventCore post(final Event event) {
        if (this.mHandler.hasMessages(event.getId())) {
            this.mHandler.removeMessages(event.getId());
        }
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Logger.d(EventCore.this.mTag, "dispatch: " + event);
                ArrayList listeners = (ArrayList)EventCore.this.mListenerMap.get(event.getId());
                if (listeners != null) {
                    for (Listener listener : listeners) {
                        listener.onEvent(event);
                    }
                }
                if (event.isSticky()) {
                    EventCore.this.mStickyEventMap.put(event.getId(), event);
                }
            }
        }, event.getDelay());
        return this;
    }

    public <T> T getEventData(int id) {
        try {
            if (this.mStickyEventMap.containsKey(id)) {
                return this.mStickyEventMap.get(id).getData();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    public EventCore registerListener(final int id, final Listener listener) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                ArrayList<Listener> listeners = (ArrayList<Listener>)EventCore.this.mListenerMap.get(id);
                if (listeners == null) {
                    listeners = new ArrayList<Listener>();
                    EventCore.this.mListenerMap.put(id, listeners);
                }
                listeners.add(listener);
                if (EventCore.this.mStickyEventMap.containsKey(id)) {
                    listener.onEvent((Event)EventCore.this.mStickyEventMap.get(id));
                }
            }
        });
        return this;
    }

    public EventCore unregisterListener(final int id, final Listener listener) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                ArrayList listeners = (ArrayList)EventCore.this.mListenerMap.get(id);
                if (listeners != null) {
                    listeners.remove(listener);
                }
            }
        });
        return this;
    }

    public EventCore loadService(final Serviceable service) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (!EventCore.this.mServices.contains(service)) {
                    EventCore.this.mServices.add(service);
                    service.onStart();
                }
            }
        });
        return this;
    }

    public EventCore unloadService(final Serviceable service) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (EventCore.this.mServices.remove(service)) {
                    service.onStop();
                }
            }
        });
        return this;
    }

    @Override
    protected synchronized void onInit() {
        if (this.mConfig == null) {
            throw new NullPointerException("context must not be null");
        }
        Logger.i(this.mTag, "onInit");
        this.mConfig = ((Context)this.mConfig).getApplicationContext();
        this.mHandlerThread = new HandlerThread(this.mTag);
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
    }

    @Override
    protected synchronized void onDestroy() {
        Logger.i(this.mTag, "onDestroy");
        if (this.mHandlerThread != null) {
            if (Utility.compatApi(18)) {
                this.quitAPI18();
            } else {
                this.mHandlerThread.quit();
            }
        }
        sInstance = null;
    }

    @TargetApi(value=18)
    private void quitAPI18() {
        this.mHandlerThread.quitSafely();
    }
}

