/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.common.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.text.TextUtils;
import com.meizu.cloud.pushsdk.common.util.Logger;
import com.meizu.cloud.pushsdk.common.util.Reflector;
import com.meizu.cloud.pushsdk.common.util.SystemProperties;
import com.meizu.cloud.pushsdk.common.util.Utility;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;

public class DeviceUtils {
    private static final String TAG = "DeviceUtils";
    private static String sMacAddr = "";
    private static String sDeviceId = "";

    public static boolean isPhone() {
        Reflector.Result result = SystemProperties.get("ro.target.product");
        if (result.ok && !TextUtils.isEmpty((CharSequence)((CharSequence)result.value))) {
            Logger.i(TAG, "current product is " + (String)result.value);
            return false;
        }
        Logger.i(TAG, "current product is phone");
        return true;
    }

    public static String getDeviceType() {
        String deviceType = null;
        Reflector.Result result = SystemProperties.get("ro.target.product");
        if (result.ok && !TextUtils.isEmpty((CharSequence)((CharSequence)result.value))) {
            Logger.i(TAG, "current product is " + (String)result.value);
            deviceType = (String)result.value;
        }
        return deviceType;
    }

    public static String getDeviceId(Context context) {
        if (TextUtils.isEmpty((CharSequence)sDeviceId)) {
            if (!DeviceUtils.isPhone()) {
                if (TextUtils.isEmpty((CharSequence)sDeviceId)) {
                    StringBuilder nonce = new StringBuilder();
                    String sn = Build.SERIAL;
                    Logger.i(TAG, "device serial " + sn);
                    if (TextUtils.isEmpty((CharSequence)sn)) {
                        return null;
                    }
                    nonce.append(sn);
                    String mac = DeviceUtils.getMACAddress(context);
                    Logger.e(TAG, "mac address " + mac);
                    if (TextUtils.isEmpty((CharSequence)mac)) {
                        return null;
                    }
                    mac = mac.replace(":", "");
                    mac = mac.toUpperCase();
                    nonce.append(mac);
                    sDeviceId = nonce.toString();
                }
            } else {
                sDeviceId = Utility.getImei(context);
            }
        }
        return sDeviceId;
    }

    public static String getMACAddress(Context context) {
        if (!TextUtils.isEmpty((CharSequence)sMacAddr)) {
            return sMacAddr;
        }
        String address = null;
        if (Build.VERSION.SDK_INT >= 23) {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            if (null != cm) {
                NetworkInfo info = cm.getActiveNetworkInfo();
                if (info != null) {
                    if (info.getType() == 1) {
                        address = DeviceUtils.getMacAddressWithIfName("wlan0");
                    } else if (info.getType() == 9) {
                        address = DeviceUtils.getMacAddressWithIfName("eth0");
                    }
                } else {
                    address = DeviceUtils.getMacAddressWithIfName("wlan0");
                    if (TextUtils.isEmpty((CharSequence)address)) {
                        address = DeviceUtils.getMacAddressWithIfName("eth0");
                    }
                }
            }
        } else {
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            if (null != wifiManager) {
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                address = wifiInfo == null ? null : wifiInfo.getMacAddress();
            }
        }
        sMacAddr = address;
        return sMacAddr;
    }

    private static String getMacAddressWithIfName(String name) {
        String address = null;
        try {
            FileInputStream in = new FileInputStream("/sys/class/net/" + name + "/address");
            Scanner reader = new Scanner(in);
            if (reader.hasNextLine()) {
                address = reader.nextLine().trim();
            }
            ((InputStream)in).close();
        }
        catch (FileNotFoundException e) {
            Logger.e(TAG, "getMacAddressWithIfName File not found Exception");
        }
        catch (IOException e) {
            Logger.e(TAG, "getMacAddressWithIfName IOException");
        }
        return address;
    }
}

