/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.common.util;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import com.meizu.cloud.pushsdk.common.util.ThreadPool;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;

public class Logger {
    private static Handler sHandler = new WriteHandler(Looper.getMainLooper());
    private static final int MSG_CALLBACK_LOG = 1;
    private static Callback sCallback;
    private static LinkedList<LogCache> sLogCaches;
    private static Callback.Level sConsoleLevel;
    private static Callback.Level sFileLevel;
    private static Option sOption;

    public static void setOutLevel(Out out, Callback.Level level) {
        if (out == Out.CONSOLE) {
            sConsoleLevel = level;
        } else if (out == Out.FILE) {
            sFileLevel = level;
        }
    }

    public static void setCallback(Callback callback) {
        sCallback = callback;
    }

    public static Option getOption() {
        return sOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flush() {
        LinkedList<LogCache> linkedList = sLogCaches;
        synchronized (linkedList) {
            sHandler.removeMessages(1);
            sHandler.obtainMessage(1).sendToTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheLog(Callback.Level level, String tag, String msg) {
        if (sCallback != null && sFileLevel.ordinal() <= level.ordinal()) {
            LinkedList<LogCache> linkedList = sLogCaches;
            synchronized (linkedList) {
                sLogCaches.addLast(new LogCache(level, tag, msg));
                if (sLogCaches.size() >= Logger.sOption.mCacheCounts || Logger.sOption.mCacheMillis <= 0) {
                    Logger.flush();
                } else if (!sHandler.hasMessages(1)) {
                    Message message = sHandler.obtainMessage(1);
                    sHandler.sendMessageDelayed(message, (long)Logger.sOption.mCacheMillis);
                }
            }
        }
    }

    public static void d(String tag, String msg) {
        if (sConsoleLevel.ordinal() <= Callback.Level.DEBUG.ordinal()) {
            Log.d((String)tag, (String)msg);
        }
        Logger.cacheLog(Callback.Level.DEBUG, tag, msg);
    }

    public static void i(String tag, String msg) {
        if (sConsoleLevel.ordinal() <= Callback.Level.INFO.ordinal()) {
            Log.i((String)tag, (String)msg);
        }
        Logger.cacheLog(Callback.Level.INFO, tag, msg);
    }

    public static void w(String tag, String msg) {
        if (sConsoleLevel.ordinal() <= Callback.Level.WARN.ordinal()) {
            Log.w((String)tag, (String)msg);
        }
        Logger.cacheLog(Callback.Level.WARN, tag, msg);
    }

    public static void e(String tag, String msg) {
        if (sConsoleLevel.ordinal() <= Callback.Level.ERROR.ordinal()) {
            Log.e((String)tag, (String)msg);
        }
        Logger.cacheLog(Callback.Level.ERROR, tag, msg);
    }

    public static void trace(String tag, Throwable tr) {
        Logger.e(tag, Log.getStackTraceString((Throwable)tr));
    }

    static {
        sLogCaches = new LinkedList();
        sConsoleLevel = Callback.Level.DEBUG;
        sFileLevel = Callback.Level.DEBUG;
        sOption = new Option();
    }

    public static class Option {
        int mCacheCounts = 100;
        int mCacheMillis = 120000;

        public Option setCacheCounts(int cacheCounts) {
            this.mCacheCounts = cacheCounts;
            return this;
        }

        public Option setCacheSeconds(int cacheMillis) {
            this.mCacheMillis = cacheMillis;
            return this;
        }
    }

    private static class WriteHandler
    extends Handler {
        WriteHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (sCallback != null) {
                ThreadPool.execute(new ThreadPool.Task(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void doInBackground() {
                        LinkedList temp;
                        LinkedList linkedList = sLogCaches;
                        synchronized (linkedList) {
                            temp = new LinkedList(sLogCaches);
                            sLogCaches.clear();
                        }
                        for (LogCache cache : temp) {
                            sCallback.print(cache.mLevel, cache.mTag, cache.mMsg);
                        }
                    }
                });
            }
        }
    }

    public static interface Callback {
        public void print(Level var1, String var2, String var3);

        public static enum Level {
            DEBUG,
            INFO,
            WARN,
            ERROR,
            NULL;

        }
    }

    public static enum Out {
        CONSOLE,
        FILE;

    }

    private static class LogCache {
        static SimpleDateFormat sDateFormat = new SimpleDateFormat("MM-dd HH:mm:ss ");
        static String sPid = String.valueOf(Process.myPid());
        Callback.Level mLevel;
        String mTag;
        String mMsg;

        LogCache(Callback.Level level, String tag, String msg) {
            this.mLevel = level;
            this.mTag = sDateFormat.format(new Date()) + sPid + "-" + String.valueOf(Thread.currentThread().getId()) + " " + tag;
            this.mMsg = msg;
        }
    }
}

