/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.common.util;

import android.text.TextUtils;
import com.meizu.cloud.pushsdk.common.util.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;

public abstract class Reflector {
    private static final String sTag = "Reflector";
    protected Object[] mArgs;
    protected Class<?>[] mTypes;
    protected String mMethodName;
    private static HashMap<String, Class<?>> sClassCache = new HashMap();
    private static HashMap<Class<?>, HashMap<String, Method>> sMethodCache = new HashMap();
    private static HashMap<String, Field> mFiledCache = new HashMap();

    public static Reflector from(Object object) {
        return new Obj(object);
    }

    public static Reflector from(Class<?> clz) {
        return new Clz(clz);
    }

    public static Reflector forName(String clzName) {
        Class<?> clz = sClassCache.get(clzName);
        if (clz == null) {
            try {
                clz = Class.forName(clzName);
                sClassCache.put(clzName, clz);
            }
            catch (ClassNotFoundException ignore) {
                Logger.trace(sTag, ignore);
            }
        }
        return Reflector.from(clz);
    }

    private static Class<?>[] getParamTypes(Object[] args) {
        Class[] paramTypes = null;
        if (args != null) {
            paramTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                paramTypes[i] = args[i].getClass();
            }
        }
        return paramTypes;
    }

    public abstract <T> Result<T> invoke();

    protected abstract Class<?> getObjClass();

    protected abstract Object getObj();

    public <T> Result<T> setFieldValue(String filedName, T value) {
        Result result = new Result();
        try {
            Field field = mFiledCache.get(filedName);
            if (field == null) {
                field = this.getObjClass().getDeclaredField(filedName);
                mFiledCache.put(filedName, field);
            }
            if (field != null) {
                field.setAccessible(true);
                field.set(this.getObj(), value);
                result = this.getFieldValue(filedName);
            }
        }
        catch (Exception ignore) {
            Logger.trace(sTag, ignore);
        }
        Logger.e(sTag, "set " + filedName + " value " + value + " result:" + result);
        return result;
    }

    public <T> Result<T> getFieldValue(String filedName) {
        Result result = new Result();
        try {
            Field field = mFiledCache.get(filedName);
            if (field == null) {
                field = this.getObjClass().getDeclaredField(filedName);
                mFiledCache.put(filedName, field);
            }
            if (field != null) {
                field.setAccessible(true);
                result.value = field.get(this.getObj());
                result.ok = true;
            }
        }
        catch (Exception ignore) {
            Logger.trace(sTag, ignore);
        }
        Logger.d(sTag, "get " + filedName + " value result:" + result);
        return result;
    }

    private static Method getMethod(Class<?> clz, String name, Class ... types) throws NoSuchMethodException {
        Method method;
        try {
            method = clz.getMethod(name, types);
        }
        catch (NoSuchMethodException e) {
            try {
                method = clz.getDeclaredMethod(name, types);
            }
            catch (NoSuchMethodException e1) {
                method = Reflector.similarMethod(clz, name, types);
            }
        }
        return method;
    }

    private static Method similarMethod(Class<?> clz, String name, Class<?>[] types) throws NoSuchMethodException {
        for (Method method : clz.getMethods()) {
            if (!Reflector.isSimilarSignature(method, name, types)) continue;
            return method;
        }
        for (Method method : clz.getDeclaredMethods()) {
            if (!Reflector.isSimilarSignature(method, name, types)) continue;
            return method;
        }
        throw new NoSuchMethodException("No similar method " + name + " with params " + Arrays.toString(types) + " could be found on type " + clz);
    }

    private static boolean isSimilarSignature(Method possiblyMatchingMethod, String desiredMethodName, Class<?>[] desiredParamTypes) {
        return possiblyMatchingMethod.getName().equals(desiredMethodName) && Reflector.match(possiblyMatchingMethod.getParameterTypes(), desiredParamTypes);
    }

    private static boolean match(Class<?>[] declaredTypes, Class<?>[] actualTypes) {
        if (declaredTypes.length == actualTypes.length) {
            for (int i = 0; i < actualTypes.length; ++i) {
                if (actualTypes[i] == NULL.class || Reflector.wrapper(declaredTypes[i]).isAssignableFrom(Reflector.wrapper(actualTypes[i]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Reflector setTypes(Class<?>[] types) {
        this.mTypes = types;
        return this;
    }

    public Reflector setArgs(Object[] args) {
        this.mArgs = args;
        return this;
    }

    public Reflector setMethodName(String methodName) {
        this.mMethodName = methodName;
        return this;
    }

    public static Class<?> wrapper(Class<?> type) {
        if (type == null) {
            return null;
        }
        if (type.isPrimitive()) {
            if (Boolean.TYPE == type) {
                return Boolean.class;
            }
            if (Integer.TYPE == type) {
                return Integer.class;
            }
            if (Long.TYPE == type) {
                return Long.class;
            }
            if (Short.TYPE == type) {
                return Short.class;
            }
            if (Byte.TYPE == type) {
                return Byte.class;
            }
            if (Double.TYPE == type) {
                return Double.class;
            }
            if (Float.TYPE == type) {
                return Float.class;
            }
            if (Character.TYPE == type) {
                return Character.class;
            }
            if (Void.TYPE == type) {
                return Void.class;
            }
        }
        return type;
    }

    private static class NULL {
        private NULL() {
        }
    }

    public static class Result<T> {
        public boolean ok = false;
        public T value;

        public String toString() {
            return "Result{ok=" + this.ok + ", value=" + this.value + '}';
        }
    }

    private static class Clz
    extends Reflector {
        private Class<?> mClz;

        public Clz(Class<?> clz) {
            this.mClz = clz;
        }

        @Override
        protected Class<?> getObjClass() {
            return this.mClz;
        }

        @Override
        protected Object getObj() {
            return this.mClz;
        }

        @Override
        public <T> Result<T> invoke() {
            Result result = new Result();
            if (this.mClz != null && !TextUtils.isEmpty((CharSequence)this.mMethodName)) {
                if (this.mArgs != null && this.mArgs.length > 0 && this.mTypes == null) {
                    this.mTypes = Reflector.getParamTypes(this.mArgs);
                }
                try {
                    Method method;
                    HashMap<String, Method> methodMap = (HashMap<String, Method>)sMethodCache.get(this.mClz);
                    if (methodMap == null) {
                        methodMap = new HashMap<String, Method>();
                        sMethodCache.put(this.mClz, methodMap);
                    }
                    if ((method = (Method)methodMap.get(this.mMethodName)) == null) {
                        method = Reflector.getMethod(this.mClz, this.mMethodName, this.mTypes);
                        if (!method.isAccessible()) {
                            method.setAccessible(true);
                        }
                        methodMap.put(this.mMethodName, method);
                    }
                    result.value = method.invoke(this.mClz, this.mArgs);
                    result.ok = true;
                }
                catch (Exception ignore) {
                    Logger.trace(Reflector.sTag, ignore);
                }
            }
            Logger.d(Reflector.sTag, "[Clz.invoke]:, mMethodName='" + this.mMethodName + ", \nmTypes=" + Arrays.toString(this.mTypes) + ", \nmArgs=" + Arrays.toString(this.mArgs) + ", \nresult=" + result);
            return result;
        }
    }

    private static class Obj
    extends Reflector {
        private Object mObject;

        public Obj(Object object) {
            this.mObject = object;
        }

        @Override
        protected Class<?> getObjClass() {
            return this.mObject.getClass();
        }

        @Override
        protected Object getObj() {
            return this.mObject;
        }

        @Override
        public <T> Result<T> invoke() {
            Result result = new Result();
            if (this.mObject != null && !TextUtils.isEmpty((CharSequence)this.mMethodName)) {
                try {
                    Method method;
                    HashMap<String, Method> methodMap;
                    if (this.mArgs != null && this.mArgs.length > 0 && this.mTypes == null) {
                        this.mTypes = Reflector.getParamTypes(this.mArgs);
                    }
                    if ((methodMap = (HashMap<String, Method>)sMethodCache.get(this.mObject.getClass())) == null) {
                        methodMap = new HashMap<String, Method>();
                        sMethodCache.put(this.mObject.getClass(), methodMap);
                    }
                    if ((method = (Method)methodMap.get(this.mMethodName)) == null) {
                        method = Reflector.getMethod(this.mObject.getClass(), this.mMethodName, this.mTypes);
                        if (!method.isAccessible()) {
                            method.setAccessible(true);
                        }
                        methodMap.put(this.mMethodName, method);
                    }
                    result.value = method.invoke(this.mObject, this.mArgs);
                    result.ok = true;
                }
                catch (Exception ignore) {
                    Logger.trace(Reflector.sTag, ignore);
                }
            }
            Logger.d(Reflector.sTag, "[Obj.invoke]:, mMethodName='" + this.mMethodName + ", \nmTypes=" + Arrays.toString(this.mTypes) + ", \nmArgs=" + Arrays.toString(this.mArgs) + ", \nresult=" + result);
            return result;
        }
    }
}

