/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.common.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.meizu.cloud.pushsdk.common.util.BuildExt;
import com.meizu.cloud.pushsdk.common.util.MzTelephoneManager;
import com.meizu.cloud.pushsdk.common.util.Reflector;
import com.meizu.cloud.pushsdk.common.util.SystemProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Utility {
    public static boolean isSame(String str1, String str2) {
        return Utility.equals(str1, str2, false);
    }

    public static boolean equals(String a, String b, boolean ignoreCase) {
        if (a == null) {
            return b == null;
        }
        if (ignoreCase) {
            return a.equalsIgnoreCase(b);
        }
        return a.equals(b);
    }

    public static boolean compatApi(int level) {
        return Build.VERSION.SDK_INT >= level;
    }

    public static String getImei(Context context) {
        if (MzTelephoneManager.getImei().ok) {
            return (String)MzTelephoneManager.getImei().value;
        }
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (tm != null) {
            return tm.getDeviceId();
        }
        return null;
    }

    public static String getSn() {
        Reflector.Result result = SystemProperties.get("ro.serialno");
        if (result.ok) {
            return (String)result.value;
        }
        return Build.SERIAL;
    }

    public static boolean isBrandMeizu() {
        Reflector.Result model = SystemProperties.get("ro.meizu.product.model");
        return model.ok && !TextUtils.isEmpty((CharSequence)((CharSequence)model.value)) || "meizu".equalsIgnoreCase(Build.BRAND) || "22c4185e".equalsIgnoreCase(Build.BRAND);
    }

    public static boolean isFlymeRom() {
        if (BuildExt.isFlymeRom().ok) {
            return (Boolean)BuildExt.isFlymeRom().value;
        }
        Reflector.Result result = SystemProperties.get("ro.meizu.rom.config");
        if (result.ok) {
            return "true".equalsIgnoreCase((String)result.value);
        }
        return false;
    }

    public static boolean isInternational() {
        return BuildExt.isInternational().ok ? (Boolean)BuildExt.isInternational().value : false;
    }

    public static boolean isIndiaLocal() {
        Reflector.Result result = SystemProperties.get("ro.meizu.locale.region");
        if (result.ok) {
            return "india".equals(result.value);
        }
        return false;
    }

    public static boolean isChinaMobileTest() {
        Reflector.Result result = SystemProperties.get("ro.chinamobile.test");
        if (result.ok) {
            return "true".equalsIgnoreCase((String)result.value);
        }
        return false;
    }

    public static String readString(InputStream stream) throws IOException {
        StringBuffer result = new StringBuffer();
        if (stream != null) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        return result.toString();
    }

    public static boolean isApplicationDebug(Context context) {
        boolean isDebug = false;
        try {
            ApplicationInfo info = context.getApplicationInfo();
            isDebug = (info.flags & 2) != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDebug;
    }

    public static String getAppVersionName(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo info = pm.getPackageInfo(context.getPackageName(), 0);
            return info.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            return "";
        }
    }
}

