/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.handler.impl.AbstractMessageHandler;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.util.UxIPUtils;

public class ThroughMessageHandler
extends AbstractMessageHandler<MessageV3> {
    public ThroughMessageHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i("AbstractMessageHandler", "start ThroughMessageHandler match");
        if (!this.canReceiveMessage(1, this.getPushServiceDefaultPackageName(intent))) {
            return false;
        }
        if ("com.meizu.flyme.push.intent.MESSAGE".equals(intent.getAction())) {
            String cloudPushMessage;
            if ("message".equals(this.getIntentMethod(intent))) {
                return true;
            }
            if (TextUtils.isEmpty((CharSequence)this.getIntentMethod(intent)) && !TextUtils.isEmpty((CharSequence)(cloudPushMessage = intent.getStringExtra("message"))) && !this.isNotificationJson(cloudPushMessage)) {
                return true;
            }
        }
        return "com.meizu.c2dm.intent.RECEIVE".equals(intent.getAction());
    }

    @Override
    public int getProcessorType() {
        return 8;
    }

    @Override
    protected MessageV3 getMessage(Intent intent) {
        MessageV3 messageV3 = new MessageV3();
        if ("com.meizu.c2dm.intent.RECEIVE".equals(intent.getAction())) {
            this.appLogicListener().onMessage(this.context(), intent);
            return null;
        }
        messageV3.setThroughMessage(intent.getStringExtra("message"));
        messageV3.setTaskId(this.getTaskId(intent));
        messageV3.setDeviceId(this.getDeviceId(intent));
        messageV3.setSeqId(this.getSeqId(intent));
        messageV3.setPushTimestamp(this.getPushTimestamp(intent));
        messageV3.setUploadDataPackageName(this.getPushServiceDefaultPackageName(intent));
        return messageV3;
    }

    @Override
    protected void unsafeSend(MessageV3 message, PushNotification pushNotification) {
        if (this.appLogicListener() != null && message != null && !TextUtils.isEmpty((CharSequence)message.getThroughMessage())) {
            this.appLogicListener().onMessage(this.context(), message.getThroughMessage());
        }
    }

    @Override
    protected void onBeforeEvent(MessageV3 message) {
        if (message != null && !TextUtils.isEmpty((CharSequence)message.getDeviceId()) && !TextUtils.isEmpty((CharSequence)message.getTaskId())) {
            UxIPUtils.onReceiveThroughMessage(this.context(), message.getUploadDataPackageName(), message.getDeviceId(), message.getTaskId(), message.getSeqId(), message.getPushTimestamp());
        }
    }
}

