/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.impl.AbstractMessageHandler;
import com.meizu.cloud.pushsdk.notification.PushNotification;

public class UnRegisterMessageHandler
extends AbstractMessageHandler<Boolean> {
    public UnRegisterMessageHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    protected Boolean getMessage(Intent intent) {
        boolean isSuccess = intent.getBooleanExtra("extra_app_is_unregister_success", false);
        String error = intent.getStringExtra("registration_error");
        String removed = intent.getStringExtra("unregistered");
        DebugLogger.i("AbstractMessageHandler", "processUnRegisterCallback 5.0:" + isSuccess + " 4.0:" + error + " 3.0:" + removed);
        if (TextUtils.isEmpty((CharSequence)error) || isSuccess || !TextUtils.isEmpty((CharSequence)removed)) {
            SharedPreferences preferences = this.context().getSharedPreferences("com.meizu.flyme.push", 0);
            preferences.edit().putString("pushId", "").commit();
            return true;
        }
        return false;
    }

    @Override
    protected void unsafeSend(Boolean message, PushNotification pushNotification) {
        if (this.appLogicListener() != null) {
            this.appLogicListener().onUnRegister(this.context(), message);
        }
    }

    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i("AbstractMessageHandler", "start UnRegisterMessageHandler match");
        return "com.meizu.flyme.push.intent.UNREGISTER.FEEDBACK".equals(intent.getAction()) || "com.meizu.c2dm.intent.UNREGISTER".equals(intent.getAction()) && TextUtils.isEmpty((CharSequence)intent.getStringExtra("unregistered"));
    }

    @Override
    public int getProcessorType() {
        return 32;
    }
}

