/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification;

import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.widget.RemoteViews;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.notification.StandardNotification;
import com.meizu.cloud.pushsdk.notification.util.RProxy;
import com.meizu.cloud.pushsdk.util.MinSdkChecker;

public class ExpandablePicNotification
extends StandardNotification {
    private static final String TAG = "ExpandablePicNotification";

    public ExpandablePicNotification(Context context, PushNotificationBuilder pushNotificationBuilder) {
        super(context, pushNotificationBuilder);
    }

    @Override
    protected void buildBigContentView(Notification notification, MessageV3 messageV3) {
        if (MinSdkChecker.isSupportNotificationBuild()) {
            RemoteViews expandedView = new RemoteViews(this.context.getPackageName(), RProxy.push_expandable_big_image_notification(this.context));
            expandedView.setTextViewText(RProxy.push_big_notification_title(this.context), (CharSequence)messageV3.getTitle());
            expandedView.setTextViewText(RProxy.push_big_notification_content(this.context), (CharSequence)messageV3.getContent());
            expandedView.setLong(RProxy.push_big_notification_date(this.context), "setTime", System.currentTimeMillis());
            this.appLargeIconSetting(expandedView, messageV3);
            this.largeExpandableImageSetting(expandedView, messageV3);
            notification.bigContentView = expandedView;
        }
    }

    private void largeExpandableImageSetting(RemoteViews expandedView, MessageV3 messageV3) {
        if (messageV3.getmNotificationStyle() != null && !this.isOnMainThread()) {
            if (!TextUtils.isEmpty((CharSequence)messageV3.getmNotificationStyle().getExpandableImageUrl())) {
                Bitmap bitmap = this.getBitmapFromURL(messageV3.getmNotificationStyle().getExpandableImageUrl());
                if (bitmap != null) {
                    expandedView.setViewVisibility(RProxy.push_big_bigview_defaultView(this.context), 0);
                    expandedView.setImageViewBitmap(RProxy.push_big_bigview_defaultView(this.context), bitmap);
                } else {
                    expandedView.setViewVisibility(RProxy.push_big_bigview_defaultView(this.context), 8);
                }
            } else {
                expandedView.setViewVisibility(RProxy.push_big_bigview_defaultView(this.context), 8);
            }
        }
    }
}

