/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import com.meizu.cloud.pushinternal.DebugLogger;
import java.io.IOException;
import java.io.InputStream;

public class ResourceReader {
    private static final String TAG = "ResourceReader";
    private Context mContext;
    private static ResourceReader mInstance;
    private AssetManager mAssetManager;

    private ResourceReader(Context context) {
        this.mContext = context;
        this.init();
    }

    public static ResourceReader getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new ResourceReader(context);
        }
        return mInstance;
    }

    private void init() {
        this.mAssetManager = this.mContext.getAssets();
    }

    public Drawable getDrawable(String var1) {
        try {
            return Drawable.createFromStream((InputStream)this.mAssetManager.open(var1), null);
        }
        catch (IOException var3) {
            var3.printStackTrace();
            return null;
        }
    }

    public Bitmap getBitmap(String var1) {
        try {
            return BitmapFactory.decodeStream((InputStream)this.mAssetManager.open(var1));
        }
        catch (IOException var3) {
            var3.printStackTrace();
            return null;
        }
    }

    public int getResId(String resName, String defType) {
        DebugLogger.i(TAG, "Get resource type " + defType + " " + resName);
        ApplicationInfo applicationInfo = this.mContext.getApplicationInfo();
        int resId = this.mContext.getResources().getIdentifier(resName, defType, applicationInfo.packageName);
        return resId;
    }
}

