/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.platform;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Parcelable;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.MessageV3;
import com.meizu.cloud.pushsdk.platform.message.BasicPushStatus;
import com.meizu.cloud.pushsdk.platform.message.PushSwitchStatus;
import com.meizu.cloud.pushsdk.platform.message.RegisterStatus;
import com.meizu.cloud.pushsdk.platform.message.SubAliasStatus;
import com.meizu.cloud.pushsdk.platform.message.SubTagsStatus;
import com.meizu.cloud.pushsdk.platform.message.UnRegisterStatus;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import java.io.Serializable;
import java.util.List;

public class PlatformMessageSender {
    public static final String TAG = "PlatformMessageSender";

    public static void sendPushStatus(Context context, final PushSwitchStatus pushSwitchStatus) {
        PlatformMessageSender.sendPlatformStatus(context, new OnUpdateIntent(){

            @Override
            public String getMethod() {
                return "push_status";
            }

            @Override
            public BasicPushStatus getBasicStatus() {
                return pushSwitchStatus;
            }

            @Override
            public String getBasicStatusExtra() {
                return "extra_app_push_switch_status";
            }
        });
    }

    public static void sendRegisterStatus(Context context, final RegisterStatus registerStatus) {
        PlatformMessageSender.sendPlatformStatus(context, new OnUpdateIntent(){

            @Override
            public String getMethod() {
                return "register_status";
            }

            @Override
            public BasicPushStatus getBasicStatus() {
                return registerStatus;
            }

            @Override
            public String getBasicStatusExtra() {
                return "extra_app_push_register_status";
            }
        });
    }

    public static void sendUnRegisterStatus(Context context, final UnRegisterStatus unRegisterStatus) {
        PlatformMessageSender.sendPlatformStatus(context, new OnUpdateIntent(){

            @Override
            public String getMethod() {
                return "un_register_status";
            }

            @Override
            public BasicPushStatus getBasicStatus() {
                return unRegisterStatus;
            }

            @Override
            public String getBasicStatusExtra() {
                return "extra_app_push_un_register_status";
            }
        });
    }

    public static void sendSubTags(Context context, final SubTagsStatus subTagsStatus) {
        PlatformMessageSender.sendPlatformStatus(context, new OnUpdateIntent(){

            @Override
            public String getMethod() {
                return "sub_tags_status";
            }

            @Override
            public BasicPushStatus getBasicStatus() {
                return subTagsStatus;
            }

            @Override
            public String getBasicStatusExtra() {
                return "extra_app_push_sub_tags_status";
            }
        });
    }

    public static void sendSubAlias(Context context, final SubAliasStatus subAliasStatus) {
        PlatformMessageSender.sendPlatformStatus(context, new OnUpdateIntent(){

            @Override
            public String getMethod() {
                return "sub_alias_status";
            }

            @Override
            public BasicPushStatus getBasicStatus() {
                return subAliasStatus;
            }

            @Override
            public String getBasicStatusExtra() {
                return "extra_app_push_sub_alias_status";
            }
        });
    }

    private static void sendPlatformStatus(Context context, OnUpdateIntent onUpdateIntent) {
        String packageName = context.getPackageName();
        Intent intent = new Intent();
        intent.addCategory(packageName);
        intent.setPackage(packageName);
        intent.putExtra("method", onUpdateIntent.getMethod());
        intent.putExtra(onUpdateIntent.getBasicStatusExtra(), (Serializable)onUpdateIntent.getBasicStatus());
        PlatformMessageSender.sendMessageFromBroadcast(context, intent, "com.meizu.flyme.push.intent.MESSAGE", context.getPackageName());
        PlatformMessageSender.sendMessageFromBroadcast(context, new Intent("com.meizu.cloud.pushservice.action.PUSH_SERVICE_START"), null, context.getPackageName());
    }

    public static void switchPushMessageSetting(Context context, int switchType, boolean switcher, String desPackageName) {
        String cloudVersionName = MzSystemUtils.getAppVersionName(context, "com.meizu.cloud");
        DebugLogger.i(TAG, context.getPackageName() + " switchPushMessageSetting cloudVersion_name " + cloudVersionName);
        if (!TextUtils.isEmpty((CharSequence)cloudVersionName) && cloudVersionName.startsWith("6")) {
            Intent pushServiceIntent = new Intent("com.meizu.flyme.push.intent.MESSAGE_SWITCH");
            pushServiceIntent.putExtra("extra_app_push_switch_setting_type", switchType);
            pushServiceIntent.putExtra("extra_app_push_switch_setting_status", switcher);
            pushServiceIntent.putExtra("extra_app_push_switch_package_name", desPackageName);
            pushServiceIntent.setClassName("com.meizu.cloud", "com.meizu.cloud.pushsdk.pushservice.MzPushService");
            context.startService(pushServiceIntent);
        }
    }

    public static void launchStartActivity(Context context, String deviceId, String packageName, String pushMessage) {
        MessageV3 messageV3 = MessageV3.parse("", deviceId, "", pushMessage);
        messageV3.setUploadDataPackageName(packageName);
        Intent serviceClickIntent = new Intent();
        serviceClickIntent.setData(Uri.parse((String)("custom://" + System.currentTimeMillis())));
        serviceClickIntent.putExtra("pushMessage", (Parcelable)messageV3);
        serviceClickIntent.putExtra("method", "private");
        serviceClickIntent.setAction("com.meizu.flyme.push.intent.MESSAGE");
        if (!TextUtils.isEmpty((CharSequence)packageName)) {
            serviceClickIntent.setPackage(packageName);
            serviceClickIntent.setClassName(packageName, "com.meizu.cloud.pushsdk.NotificationService");
        }
        serviceClickIntent.putExtra("command_type", "reflect_receiver");
        DebugLogger.i(TAG, "start notification service " + messageV3);
        try {
            context.startService(serviceClickIntent);
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "launchStartActivity error " + e.getMessage());
        }
    }

    public static void sendMessageFromBroadcast(Context paramContext, Intent paramIntent, String action, String packageName) {
        String name;
        if (!TextUtils.isEmpty((CharSequence)action)) {
            paramIntent.setAction(action);
        }
        if (!TextUtils.isEmpty((CharSequence)packageName)) {
            paramIntent.setPackage(packageName);
        }
        if (!TextUtils.isEmpty((CharSequence)(name = PlatformMessageSender.findReceiver(paramContext, action, packageName)))) {
            paramIntent.setClassName(packageName, name);
        }
        paramContext.sendBroadcast(paramIntent);
    }

    private static String findReceiver(Context paramContext, String action, String packageName) {
        if (TextUtils.isEmpty((CharSequence)action) || TextUtils.isEmpty((CharSequence)packageName)) {
            return null;
        }
        Intent localIntent = new Intent(action);
        localIntent.setPackage(packageName);
        List localList = paramContext.getPackageManager().queryBroadcastReceivers(localIntent, 0);
        if (localList != null && localList.size() > 0) {
            return ((ResolveInfo)localList.get((int)0)).activityInfo.name;
        }
        return null;
    }

    private static interface OnUpdateIntent {
        public String getMethod();

        public BasicPushStatus getBasicStatus();

        public String getBasicStatusExtra();
    }
}

