/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.platform.api;

import android.content.Context;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.common.util.Utility;
import com.meizu.cloud.pushsdk.networking.AndroidNetworking;
import com.meizu.cloud.pushsdk.networking.common.ANRequest;
import com.meizu.cloud.pushsdk.networking.interfaces.OkHttpResponseAndStringRequestListener;
import com.meizu.cloud.pushsdk.platform.SignUtils;
import java.util.LinkedHashMap;

public class PushAPI {
    public static final String TAG = "PushAPI";
    public String API_SERVER = "https://api-push.meizu.com/garcia/api/client/";
    private String REGISTER_URL_PRIX = this.API_SERVER + "message/registerPush";
    private String UNREGISTER_URL_PRIX = this.API_SERVER + "message/unRegisterPush";
    private String UNREGISTER_URL_ADVANCE_PRIX = this.API_SERVER + "advance/unRegisterPush";
    private String CHECK_REGISTER_SWITCH_STATUS_URL_PRIX = this.API_SERVER + "message/getRegisterSwitch";
    private String CHANGE_REGISTER_SWITCH_STATUS_URL_PRIX = this.API_SERVER + "message/changeRegisterSwitch";
    private String SUBSCRIBE_TAGS_URL_PRIX = this.API_SERVER + "message/subscribeTags";
    private String UNSUBSCRIBE_TAGS_URL_PRIX = this.API_SERVER + "message/unSubscribeTags";
    private String CHECK_SUBSCRIBE_TAGS_URL_PRIX = this.API_SERVER + "message/getSubTags";
    private String SUBSCRIBE_ALIAS_URL_PRIX = this.API_SERVER + "message/subscribeAlias";
    private String UNSUBSCRIBE_ALIAS_URL_PRIX = this.API_SERVER + "message/unSubscribeAlias";
    private String CHECK_SUBSCRIBE_ALIAS_URL_PRIX = this.API_SERVER + "message/getSubAlias";

    public PushAPI(Context mContext) {
        AndroidNetworking.enableLogging();
        if (Utility.isInternational() || Utility.isIndiaLocal()) {
            this.API_SERVER = "https://api-push.in.meizu.com/garcia/api/client/";
            this.REGISTER_URL_PRIX = this.API_SERVER + "message/registerPush";
            this.UNREGISTER_URL_PRIX = this.API_SERVER + "message/unRegisterPush";
            this.UNREGISTER_URL_ADVANCE_PRIX = this.API_SERVER + "advance/unRegisterPush";
            this.CHECK_REGISTER_SWITCH_STATUS_URL_PRIX = this.API_SERVER + "message/getRegisterSwitch";
            this.CHANGE_REGISTER_SWITCH_STATUS_URL_PRIX = this.API_SERVER + "message/changeRegisterSwitch";
            this.SUBSCRIBE_TAGS_URL_PRIX = this.API_SERVER + "message/subscribeTags";
            this.UNSUBSCRIBE_TAGS_URL_PRIX = this.API_SERVER + "message/unSubscribeTags";
            this.CHECK_SUBSCRIBE_TAGS_URL_PRIX = this.API_SERVER + "message/getSubTags";
            this.SUBSCRIBE_ALIAS_URL_PRIX = this.API_SERVER + "message/subscribeAlias";
            this.UNSUBSCRIBE_ALIAS_URL_PRIX = this.API_SERVER + "message/unSubscribeAlias";
            this.CHECK_SUBSCRIBE_ALIAS_URL_PRIX = this.API_SERVER + "message/getSubAlias";
        }
    }

    public void register(String appId, String appKey, String deviceId, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("deviceId", deviceId);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "register post map " + requestMap);
        ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.REGISTER_URL_PRIX).addBodyParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public void unRegister(String appId, String appKey, String deviceId, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("deviceId", deviceId);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "unregister post map " + requestMap);
        ((ANRequest.GetRequestBuilder)AndroidNetworking.get(this.UNREGISTER_URL_PRIX).addQueryParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public void unRegister(String packageName, String deviceId, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("packageName", packageName);
        paramsMap.put("deviceId", deviceId);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, "4a2ca769d79f4856bb3bd982d30de790"));
        DebugLogger.i(TAG, "advance unregister post map " + requestMap);
        ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.UNREGISTER_URL_ADVANCE_PRIX).addBodyParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public void checkPush(String appId, String appKey, String pushId, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "checkPush post map " + requestMap);
        ((ANRequest.GetRequestBuilder)AndroidNetworking.get(this.CHECK_REGISTER_SWITCH_STATUS_URL_PRIX).addQueryParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public void switchPush(String appId, String appKey, String pushId, int msgType, boolean switcher, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("msgType", String.valueOf(msgType));
        paramsMap.put("subSwitch", switcher ? "1" : "0");
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "swithPush post map " + requestMap);
        ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.CHANGE_REGISTER_SWITCH_STATUS_URL_PRIX).addBodyParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public void subScribeTags(String appId, String appKey, String pushId, String args, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("tags", args);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.SUBSCRIBE_TAGS_URL_PRIX).addBodyParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public void unSubScribeTags(String appId, String appKey, String pushId, String args, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("tags", args);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.UNSUBSCRIBE_TAGS_URL_PRIX).addBodyParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public void checkSubScribeTags(String appId, String appKey, String pushId, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "checkPush post map " + requestMap);
        ((ANRequest.GetRequestBuilder)AndroidNetworking.get(this.CHECK_SUBSCRIBE_TAGS_URL_PRIX).addQueryParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public void subScribeAlias(String appId, String appKey, String pushId, String alias, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("appKey", appKey);
        paramsMap.put("pushId", pushId);
        paramsMap.put("alias", alias);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.SUBSCRIBE_ALIAS_URL_PRIX).addBodyParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public void unSubScribeAlias(String appId, String appKey, String pushId, String alias, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        paramsMap.put("alias", alias);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "subScribeTags post map " + requestMap);
        ((ANRequest.PostRequestBuilder)AndroidNetworking.post(this.UNSUBSCRIBE_ALIAS_URL_PRIX).addBodyParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }

    public void checkSubScribeAlias(String appId, String appKey, String pushId, OkHttpResponseAndStringRequestListener okHttpResponseAndStringRequestListener) {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("appId", appId);
        paramsMap.put("pushId", pushId);
        LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>();
        requestMap.putAll(paramsMap);
        requestMap.put("sign", SignUtils.getSignature(paramsMap, appKey));
        DebugLogger.i(TAG, "checkPush post map " + requestMap);
        ((ANRequest.GetRequestBuilder)AndroidNetworking.get(this.CHECK_SUBSCRIBE_ALIAS_URL_PRIX).addQueryParameter(requestMap)).build().getAsOkHttpResponseAndString(okHttpResponseAndStringRequestListener);
    }
}

