/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.platform.api;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.networking.error.ANError;
import com.meizu.cloud.pushsdk.networking.http.Response;
import com.meizu.cloud.pushsdk.networking.interfaces.OkHttpResponseAndStringRequestListener;
import com.meizu.cloud.pushsdk.platform.PlatformMessageSender;
import com.meizu.cloud.pushsdk.platform.api.PushAPI;
import com.meizu.cloud.pushsdk.platform.message.PushSwitchStatus;
import com.meizu.cloud.pushsdk.platform.message.RegisterStatus;
import com.meizu.cloud.pushsdk.platform.message.SubAliasStatus;
import com.meizu.cloud.pushsdk.platform.message.SubTagsStatus;
import com.meizu.cloud.pushsdk.platform.message.UnRegisterStatus;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class PushPlatformManager {
    private static final String TAG = "PushPlatformManager";
    private static PushPlatformManager mInstance;
    private ScheduledExecutorService executorService;
    private Handler mainHandler;
    private Context mContext;
    private PushAPI pushAPI;
    private int deviceIdRetry = 0;

    public PushPlatformManager(Context context) {
        this.mContext = context;
        this.pushAPI = new PushAPI(context);
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.mainHandler = new Handler(this.mContext.getMainLooper()){

            public void handleMessage(Message msg) {
                String deviceId = msg.getData().getString("deviceId");
                String appId = msg.getData().getString("appId");
                String appKey = msg.getData().getString("appKey");
                switch (msg.what) {
                    case 0: {
                        PushPlatformManager.this.register(appId, appKey, deviceId);
                        break;
                    }
                    case 1: {
                        PushPlatformManager.this.unRegister(appId, appKey, deviceId);
                        break;
                    }
                    case 2: {
                        String packageName = msg.getData().getString("packageName");
                        PushPlatformManager.this.unRegisterAdvance(packageName, deviceId);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PushPlatformManager getInstance(Context context) {
        if (mInstance != null) return mInstance;
        Class<PushPlatformManager> clazz = PushPlatformManager.class;
        synchronized (PushPlatformManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new PushPlatformManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    public void register(String appId, String appKey) {
        String pushId = PushPreferencesUtils.getPushId(this.mContext);
        int expireTime = PushPreferencesUtils.getPushIdExpireTime(this.mContext);
        if (!TextUtils.isEmpty((CharSequence)pushId) && System.currentTimeMillis() / 1000L < (long)expireTime) {
            RegisterStatus registerStatus = new RegisterStatus();
            registerStatus.setCode("200");
            registerStatus.setMessage("already register PushId,dont register frequently");
            registerStatus.setPushId(pushId);
            registerStatus.setExpireTime((int)((long)expireTime - System.currentTimeMillis() / 1000L));
            PlatformMessageSender.sendRegisterStatus(this.mContext, registerStatus);
        } else {
            PushPreferencesUtils.putPushId(this.mContext, "");
            DebugLogger.i(TAG, "after " + this.deviceIdRetry * 10 + " seconds start register");
            this.executeAfterGetDeviceId(0, appId, appKey, this.deviceIdRetry * 10);
        }
    }

    public void register(String appId, String appKey, String deviceId) {
        if (TextUtils.isEmpty((CharSequence)deviceId) && this.deviceIdRetry++ < 3) {
            DebugLogger.e(TAG, "Get deviceId error so after " + this.deviceIdRetry * 10 + " seconds retry register");
            this.executeAfterGetDeviceId(0, appId, appKey, this.deviceIdRetry * 10);
        } else {
            DebugLogger.i(TAG, "device retry count " + this.deviceIdRetry);
            this.deviceIdRetry = 0;
            this.pushAPI.register(appId, appKey, deviceId, new OkHttpResponseAndStringRequestListener(){

                @Override
                public void onResponse(Response okHttpResponse, String response) {
                    DebugLogger.e(PushPlatformManager.TAG, response.toString());
                    RegisterStatus registerStatus = new RegisterStatus(response.toString());
                    DebugLogger.e(PushPlatformManager.TAG, "registerStatus " + registerStatus);
                    PlatformMessageSender.sendRegisterStatus(PushPlatformManager.this.mContext, registerStatus);
                }

                @Override
                public void onError(ANError error) {
                    if (error.getResponse() != null) {
                        DebugLogger.e(PushPlatformManager.TAG, "status code=" + error.getErrorCode() + " data=" + error.getResponse());
                    }
                    RegisterStatus registerStatus = new RegisterStatus();
                    registerStatus.setCode(String.valueOf(error.getErrorCode()));
                    registerStatus.setMessage(error.getErrorBody());
                    DebugLogger.e(PushPlatformManager.TAG, "registerStatus " + registerStatus);
                    PlatformMessageSender.sendRegisterStatus(PushPlatformManager.this.mContext, registerStatus);
                }
            });
        }
    }

    public void register0(String appId, String appKey, String deviceId) {
        DebugLogger.e(TAG, "PushService default package start register");
        this.pushAPI.register(appId, appKey, deviceId, new OkHttpResponseAndStringRequestListener(){

            @Override
            public void onResponse(Response okHttpResponse, String response) {
                DebugLogger.e(PushPlatformManager.TAG, "Push Service" + response.toString());
            }

            @Override
            public void onError(ANError anError) {
                DebugLogger.e(PushPlatformManager.TAG, "error code " + anError.getMessage());
            }
        });
    }

    public void unRegister(String appId, String appKey) {
        String pushId = PushPreferencesUtils.getPushId(this.mContext);
        if (TextUtils.isEmpty((CharSequence)pushId)) {
            UnRegisterStatus unRegisterStatus = new UnRegisterStatus();
            unRegisterStatus.setCode("200");
            unRegisterStatus.setMessage("already unRegister PushId,dont unRegister frequently");
            unRegisterStatus.setIsUnRegisterSuccess(true);
            PlatformMessageSender.sendUnRegisterStatus(this.mContext, unRegisterStatus);
        } else {
            this.executeAfterGetDeviceId(1, appId, appKey, 0L);
        }
    }

    public void unRegister(String appId, String appKey, String deviceId) {
        this.pushAPI.unRegister(appId, appKey, deviceId, new OkHttpResponseAndStringRequestListener(){

            @Override
            public void onResponse(Response okHttpResponse, String response) {
                DebugLogger.e(PushPlatformManager.TAG, "unRegister" + response.toString());
                UnRegisterStatus unRegisterStatus = new UnRegisterStatus(response.toString());
                DebugLogger.e(PushPlatformManager.TAG, "unRegisterStatus " + unRegisterStatus);
                PlatformMessageSender.sendUnRegisterStatus(PushPlatformManager.this.mContext, unRegisterStatus);
            }

            @Override
            public void onError(ANError anError) {
                UnRegisterStatus unRegisterStatus = new UnRegisterStatus();
                unRegisterStatus.setCode(String.valueOf(anError.getErrorCode()));
                unRegisterStatus.setIsUnRegisterSuccess(false);
                unRegisterStatus.setMessage(anError.getErrorBody());
                DebugLogger.e(PushPlatformManager.TAG, "unRegisterStatus " + unRegisterStatus);
                PlatformMessageSender.sendUnRegisterStatus(PushPlatformManager.this.mContext, unRegisterStatus);
            }
        });
    }

    public void unRegisterAdvance(final String packageName) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                String deviceId = MzSystemUtils.getDeviceId(PushPlatformManager.this.mContext);
                Message message = PushPlatformManager.this.mainHandler.obtainMessage();
                Bundle bundle = new Bundle();
                bundle.putString("deviceId", deviceId);
                bundle.putString("packageName", packageName);
                message.setData(bundle);
                message.what = 2;
                DebugLogger.e(PushPlatformManager.TAG, "deviceId " + deviceId + "packageName " + packageName);
                PushPlatformManager.this.mainHandler.sendMessage(message);
            }
        });
    }

    public void unRegisterAdvance(final String packageName, String deviceId) {
        this.pushAPI.unRegister(packageName, deviceId, new OkHttpResponseAndStringRequestListener(){

            @Override
            public void onResponse(Response okHttpResponse, String response) {
                DebugLogger.e(PushPlatformManager.TAG, "unregisetr advance pakcage " + packageName + " result " + response);
            }

            @Override
            public void onError(ANError anError) {
                DebugLogger.e(PushPlatformManager.TAG, "unregisetr advance pakcage " + packageName + " error " + anError.getErrorBody());
            }
        });
    }

    public void checkPush(String appId, String appKey, String pushId) {
        this.pushAPI.checkPush(appId, appKey, pushId, new OkHttpResponseAndStringRequestListener(){

            @Override
            public void onResponse(Response okHttpResponse, String response) {
                DebugLogger.e(PushPlatformManager.TAG, "checkPush" + response.toString());
                PushSwitchStatus pushSwitchStatus = new PushSwitchStatus(response.toString());
                DebugLogger.e(PushPlatformManager.TAG, "pushSwitchStatus " + pushSwitchStatus);
                PlatformMessageSender.sendPushStatus(PushPlatformManager.this.mContext, pushSwitchStatus);
            }

            @Override
            public void onError(ANError anError) {
                PushSwitchStatus pushSwitchStatus = new PushSwitchStatus();
                pushSwitchStatus.setCode(String.valueOf(anError.getErrorCode()));
                pushSwitchStatus.setMessage(anError.getErrorBody());
                DebugLogger.e(PushPlatformManager.TAG, "pushSwitchStatus " + pushSwitchStatus);
                PlatformMessageSender.sendPushStatus(PushPlatformManager.this.mContext, pushSwitchStatus);
            }
        });
    }

    public void switchPush(String appId, String appKey, String pushId, int msgType, boolean switcher) {
        if (msgType == 0) {
            PushPreferencesUtils.setNotificationMessageSwitchStatus(this.mContext, this.mContext.getPackageName(), switcher);
        } else if (msgType == 1) {
            PushPreferencesUtils.setThroughMessageSwitchStatus(this.mContext, this.mContext.getPackageName(), switcher);
        }
        this.pushAPI.switchPush(appId, appKey, pushId, msgType, switcher, new OkHttpResponseAndStringRequestListener(){

            @Override
            public void onResponse(Response okHttpResponse, String response) {
                DebugLogger.e(PushPlatformManager.TAG, "switchPush" + response.toString());
                PushSwitchStatus pushSwitchStatus = new PushSwitchStatus(response.toString());
                DebugLogger.e(PushPlatformManager.TAG, "switchPush" + pushSwitchStatus);
                PlatformMessageSender.sendPushStatus(PushPlatformManager.this.mContext, pushSwitchStatus);
            }

            @Override
            public void onError(ANError anError) {
                PushSwitchStatus pushSwitchStatus = new PushSwitchStatus();
                pushSwitchStatus.setCode(String.valueOf(anError.getErrorCode()));
                pushSwitchStatus.setMessage(anError.getErrorBody());
                DebugLogger.e(PushPlatformManager.TAG, "pushSwitchStatus " + pushSwitchStatus);
                PlatformMessageSender.sendPushStatus(PushPlatformManager.this.mContext, pushSwitchStatus);
            }
        });
        PlatformMessageSender.switchPushMessageSetting(this.mContext, msgType, switcher, this.mContext.getPackageName());
    }

    public void subScribeTags(String appId, String appKey, String pushId, String tags) {
        this.pushAPI.subScribeTags(appId, appKey, pushId, tags, new OkHttpResponseAndStringRequestListener(){

            @Override
            public void onResponse(Response okHttpResponse, String response) {
                DebugLogger.e(PushPlatformManager.TAG, "subScribeTags" + response.toString());
                SubTagsStatus subTagsStatus = new SubTagsStatus(response.toString());
                DebugLogger.e(PushPlatformManager.TAG, "subScribeTags " + subTagsStatus.getTagList());
                PlatformMessageSender.sendSubTags(PushPlatformManager.this.mContext, subTagsStatus);
            }

            @Override
            public void onError(ANError anError) {
                SubTagsStatus subTagsStatus = new SubTagsStatus();
                subTagsStatus.setCode(String.valueOf(anError.getErrorCode()));
                subTagsStatus.setMessage(anError.getErrorBody());
                DebugLogger.e(PushPlatformManager.TAG, "subScribeTags " + subTagsStatus);
                PlatformMessageSender.sendSubTags(PushPlatformManager.this.mContext, subTagsStatus);
            }
        });
    }

    public void unSubScribeTags(String appId, String appKey, String pushId, String tags) {
        this.pushAPI.unSubScribeTags(appId, appKey, pushId, tags, new OkHttpResponseAndStringRequestListener(){

            @Override
            public void onResponse(Response okHttpResponse, String response) {
                DebugLogger.e(PushPlatformManager.TAG, "unSubScribeTags " + response.toString());
                SubTagsStatus subTagsStatus = new SubTagsStatus(response.toString());
                DebugLogger.e(PushPlatformManager.TAG, "unSubScribeTags " + subTagsStatus);
                PlatformMessageSender.sendSubTags(PushPlatformManager.this.mContext, subTagsStatus);
            }

            @Override
            public void onError(ANError anError) {
                SubTagsStatus subTagsStatus = new SubTagsStatus();
                subTagsStatus.setCode(String.valueOf(anError.getErrorCode()));
                subTagsStatus.setMessage(anError.getErrorBody());
                DebugLogger.e(PushPlatformManager.TAG, "subScribeTags " + subTagsStatus);
                PlatformMessageSender.sendSubTags(PushPlatformManager.this.mContext, subTagsStatus);
            }
        });
    }

    public void checkSubScribeTags(String appId, String appKey, String pushId) {
        this.pushAPI.checkSubScribeTags(appId, appKey, pushId, new OkHttpResponseAndStringRequestListener(){

            @Override
            public void onResponse(Response okHttpResponse, String response) {
                DebugLogger.e(PushPlatformManager.TAG, "checkSubScribeTags " + response.toString());
                SubTagsStatus subTagsStatus = new SubTagsStatus(response.toString());
                DebugLogger.e(PushPlatformManager.TAG, "checkSubScribeTags " + subTagsStatus);
                PlatformMessageSender.sendSubTags(PushPlatformManager.this.mContext, subTagsStatus);
            }

            @Override
            public void onError(ANError anError) {
                SubTagsStatus subTagsStatus = new SubTagsStatus();
                subTagsStatus.setCode(String.valueOf(anError.getErrorCode()));
                subTagsStatus.setMessage(anError.getErrorDetail() + anError.getErrorBody());
                DebugLogger.e(PushPlatformManager.TAG, "subScribeTags " + subTagsStatus);
                PlatformMessageSender.sendSubTags(PushPlatformManager.this.mContext, subTagsStatus);
            }
        });
    }

    public void subScribeAlias(String appId, String appKey, String pushId, String alias) {
        this.pushAPI.subScribeAlias(appId, appKey, pushId, alias, new OkHttpResponseAndStringRequestListener(){

            @Override
            public void onResponse(Response okHttpResponse, String response) {
                DebugLogger.e(PushPlatformManager.TAG, "subScribeAlias " + response.toString());
                SubAliasStatus subAliasStatus = new SubAliasStatus(response.toString());
                DebugLogger.e(PushPlatformManager.TAG, "subScribeAlias " + subAliasStatus);
                PlatformMessageSender.sendSubAlias(PushPlatformManager.this.mContext, subAliasStatus);
            }

            @Override
            public void onError(ANError anError) {
                SubAliasStatus subAliasStatus = new SubAliasStatus();
                subAliasStatus.setCode(String.valueOf(anError.getErrorCode()));
                subAliasStatus.setMessage(anError.getErrorDetail() + " " + anError.getErrorBody());
                DebugLogger.e(PushPlatformManager.TAG, "subScribeAlias " + subAliasStatus);
                PlatformMessageSender.sendSubAlias(PushPlatformManager.this.mContext, subAliasStatus);
            }
        });
    }

    public void unSubScribeAlias(String appId, String appKey, String pushId, String alias) {
        this.pushAPI.unSubScribeAlias(appId, appKey, pushId, alias, new OkHttpResponseAndStringRequestListener(){

            @Override
            public void onResponse(Response okHttpResponse, String response) {
                DebugLogger.e(PushPlatformManager.TAG, "unSubScribeAlias " + response.toString());
                SubAliasStatus subAliasStatus = new SubAliasStatus(response.toString());
                DebugLogger.e(PushPlatformManager.TAG, "unSubScribeAlias " + subAliasStatus);
                PlatformMessageSender.sendSubAlias(PushPlatformManager.this.mContext, subAliasStatus);
            }

            @Override
            public void onError(ANError anError) {
                SubAliasStatus subAliasStatus = new SubAliasStatus();
                subAliasStatus.setCode(String.valueOf(anError.getErrorCode()));
                subAliasStatus.setMessage(anError.getErrorBody());
                DebugLogger.e(PushPlatformManager.TAG, "subScribeAlias " + subAliasStatus);
                PlatformMessageSender.sendSubAlias(PushPlatformManager.this.mContext, subAliasStatus);
            }
        });
    }

    public void checkSubScribeAlias(String appId, String appKey, String pushId) {
        this.pushAPI.checkSubScribeAlias(appId, appKey, pushId, new OkHttpResponseAndStringRequestListener(){

            @Override
            public void onResponse(Response okHttpResponse, String response) {
                DebugLogger.e(PushPlatformManager.TAG, "checkSubScribeAlias " + response.toString());
                SubAliasStatus subAliasStatus = new SubAliasStatus(response.toString());
                DebugLogger.e(PushPlatformManager.TAG, "checkSubScribeAlias " + subAliasStatus);
                PlatformMessageSender.sendSubAlias(PushPlatformManager.this.mContext, subAliasStatus);
            }

            @Override
            public void onError(ANError anError) {
                SubAliasStatus subAliasStatus = new SubAliasStatus();
                subAliasStatus.setCode(String.valueOf(anError.getErrorCode()));
                subAliasStatus.setMessage(anError.getErrorBody());
                DebugLogger.e(PushPlatformManager.TAG, "subScribeAlias " + subAliasStatus);
                PlatformMessageSender.sendSubAlias(PushPlatformManager.this.mContext, subAliasStatus);
            }
        });
    }

    private void executeAfterGetDeviceId(final int type, final String appId, final String appkey, long delay) {
        this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                String deviceId = MzSystemUtils.getDeviceId(PushPlatformManager.this.mContext);
                Message message = PushPlatformManager.this.mainHandler.obtainMessage();
                Bundle bundle = new Bundle();
                bundle.putString("deviceId", deviceId);
                bundle.putString("appId", appId);
                bundle.putString("appKey", appkey);
                message.setData(bundle);
                message.what = type;
                DebugLogger.e(PushPlatformManager.TAG, "deviceId " + deviceId);
                PushPlatformManager.this.mainHandler.sendMessage(message);
                if (!TextUtils.isEmpty((CharSequence)deviceId)) {
                    DebugLogger.i(PushPlatformManager.TAG, "put deviceId " + deviceId + " to preference");
                    PushPreferencesUtils.putDeviceId(PushPlatformManager.this.mContext, deviceId);
                }
            }
        }, delay, TimeUnit.SECONDS);
    }
}

