/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.pushtracer;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.common.util.Utility;
import com.meizu.cloud.pushsdk.pushtracer.emitter.BufferOption;
import com.meizu.cloud.pushsdk.pushtracer.emitter.Emitter;
import com.meizu.cloud.pushsdk.pushtracer.emitter.RequestCallback;
import com.meizu.cloud.pushsdk.pushtracer.emitter.classic.Emitter;
import com.meizu.cloud.pushsdk.pushtracer.tracker.Subject;
import com.meizu.cloud.pushsdk.pushtracer.tracker.Tracker;
import com.meizu.cloud.pushsdk.pushtracer.utils.LogLevel;
import com.meizu.cloud.pushsdk.pushtracer.utils.Logger;
import com.meizu.cloud.pushsdk.pushtracer.utils.Util;

public class QuickTracker {
    public static final String namespace = "PushAndroidTracker";
    private static Tracker tracker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Tracker getAndroidTrackerClassic(Context context, RequestCallback callback) {
        Subject subject = QuickTracker.getSubject(context);
        if (tracker != null) return tracker;
        Class<QuickTracker> clazz = QuickTracker.class;
        synchronized (QuickTracker.class) {
            if (tracker != null) return tracker;
            com.meizu.cloud.pushsdk.pushtracer.emitter.Emitter emitter = QuickTracker.getEmitterClassic(context, callback);
            tracker = QuickTracker.getTrackerClassic(emitter, subject, context);
            QuickTracker.registerNetworkReceiver(context, tracker);
            tracker.setSubject(subject);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return tracker;
        }
    }

    private static Tracker getTrackerClassic(com.meizu.cloud.pushsdk.pushtracer.emitter.Emitter emitter, Subject subject, Context context) {
        return new com.meizu.cloud.pushsdk.pushtracer.tracker.classic.Tracker(new Tracker.TrackerBuilder(emitter, namespace, context.getPackageCodePath(), context, com.meizu.cloud.pushsdk.pushtracer.tracker.classic.Tracker.class).level(LogLevel.VERBOSE).base64(false).subject(subject).threadCount(2));
    }

    private static com.meizu.cloud.pushsdk.pushtracer.emitter.Emitter getEmitterClassic(Context context, RequestCallback callback) {
        return new Emitter(new Emitter.EmitterBuilder(QuickTracker.getStaticsDomain(), context, Emitter.class).callback(callback).tick(1).option(BufferOption.Single).sendLimit(1).emptyLimit(2));
    }

    private static Subject getSubject(Context context) {
        return new Subject.SubjectBuilder().context(context).build();
    }

    private static void registerNetworkReceiver(Context context, final Tracker tracker) {
        IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (Util.isOnline(context)) {
                    Logger.e("QuickTracker", "restart track event: %s", "online true");
                    tracker.restartEventTracking();
                }
            }
        }, filter);
    }

    private static String getStaticsDomain() {
        String staticsDomian = "push-statics.meizu.com";
        if (Utility.isInternational() || Utility.isIndiaLocal()) {
            return "push-statics.in.meizu.com";
        }
        DebugLogger.e("QuickTracker", "current statics domain is " + staticsDomian);
        return staticsDomian;
    }
}

