/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.pushtracer.storage;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import com.meizu.cloud.pushsdk.pushtracer.dataload.DataLoad;
import com.meizu.cloud.pushsdk.pushtracer.dataload.TrackerDataload;
import com.meizu.cloud.pushsdk.pushtracer.emitter.EmittableEvents;
import com.meizu.cloud.pushsdk.pushtracer.storage.EventStoreHelper;
import com.meizu.cloud.pushsdk.pushtracer.utils.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class EventStore {
    private String TAG = EventStore.class.getSimpleName();
    private SQLiteDatabase database;
    private EventStoreHelper dbHelper;
    private String[] allColumns = new String[]{"id", "eventData", "dateCreated"};
    private long lastInsertedRowId = -1L;
    private int sendLimit;

    public EventStore(Context context, int sendLimit) {
        this.dbHelper = EventStoreHelper.getInstance(context);
        this.open();
        this.sendLimit = sendLimit;
        Logger.d(this.TAG, "DB Path: " + this.database.getPath(), new Object[0]);
    }

    public void add(DataLoad dataLoad) {
        this.insertEvent(dataLoad);
    }

    public void open() {
        if (!this.isDatabaseOpen()) {
            this.database = this.dbHelper.getWritableDatabase();
            this.database.enableWriteAheadLogging();
        }
    }

    public void close() {
        this.dbHelper.close();
    }

    public long insertEvent(DataLoad dataLoad) {
        if (this.isDatabaseOpen()) {
            byte[] bytes = EventStore.serialize(dataLoad.getMap());
            ContentValues values = new ContentValues(2);
            values.put("eventData", bytes);
            this.lastInsertedRowId = this.database.insert("events", null, values);
        }
        Logger.d(this.TAG, "Added event to database: " + this.lastInsertedRowId, new Object[0]);
        return this.lastInsertedRowId;
    }

    public boolean removeEvent(long id) {
        int retval = -1;
        if (this.isDatabaseOpen()) {
            retval = this.database.delete("events", "id=" + id, null);
        }
        Logger.d(this.TAG, "Removed event from database: " + id, new Object[0]);
        return retval == 1;
    }

    public boolean removeAllEvents() {
        int retval = -1;
        if (this.isDatabaseOpen()) {
            retval = this.database.delete("events", null, null);
        }
        Logger.d(this.TAG, "Removing all events from database.", new Object[0]);
        return retval == 0;
    }

    private static byte[] serialize(Map<String, String> map) {
        try {
            ByteArrayOutputStream mem_out = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(mem_out);
            out.writeObject(map);
            out.close();
            mem_out.close();
            return mem_out.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Map<String, String> deserializer(byte[] bytes) {
        try {
            ByteArrayInputStream mem_in = new ByteArrayInputStream(bytes);
            ObjectInputStream in = new ObjectInputStream(mem_in);
            HashMap map = (HashMap)in.readObject();
            in.close();
            mem_in.close();
            return map;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Map<String, Object>> queryDatabase(String query, String orderBy) {
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
        if (this.isDatabaseOpen()) {
            Cursor cursor = this.database.query("events", this.allColumns, query, null, null, null, orderBy);
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                HashMap<String, Object> eventMetadata = new HashMap<String, Object>();
                eventMetadata.put("id", cursor.getLong(0));
                eventMetadata.put("eventData", EventStore.deserializer(cursor.getBlob(1)));
                eventMetadata.put("dateCreated", cursor.getString(2));
                cursor.moveToNext();
                res.add(eventMetadata);
            }
            cursor.close();
        }
        return res;
    }

    public long getSize() {
        return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.database, (String)"events");
    }

    public long getLastInsertedRowId() {
        return this.lastInsertedRowId;
    }

    public EmittableEvents getEmittableEvents() {
        LinkedList<Long> eventIds = new LinkedList<Long>();
        ArrayList<DataLoad> events = new ArrayList<DataLoad>();
        for (Map<String, Object> eventMetadata : this.getDescEventsInRange(this.sendLimit)) {
            TrackerDataload payload = new TrackerDataload();
            Map eventData = (Map)eventMetadata.get("eventData");
            payload.addMap(eventData);
            Long eventId = (Long)eventMetadata.get("id");
            eventIds.add(eventId);
            events.add(payload);
        }
        return new EmittableEvents(events, eventIds);
    }

    public Map<String, Object> getEvent(long id) {
        List<Map<String, Object>> res = this.queryDatabase("id=" + id, null);
        if (!res.isEmpty()) {
            return res.get(0);
        }
        return null;
    }

    public List<Map<String, Object>> getAllEvents() {
        return this.queryDatabase(null, null);
    }

    public List<Map<String, Object>> getDescEventsInRange(int range) {
        return this.queryDatabase(null, "id ASC LIMIT " + range);
    }

    public boolean isDatabaseOpen() {
        return this.database != null && this.database.isOpen();
    }
}

