/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.pushtracer.tracker;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.location.Location;
import android.os.Build;
import android.view.Display;
import android.view.WindowManager;
import com.meizu.cloud.pushsdk.pushtracer.utils.Logger;
import com.meizu.cloud.pushsdk.pushtracer.utils.Util;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class Subject {
    private static String TAG = Subject.class.getSimpleName();
    private HashMap<String, String> standardPairs = new HashMap();
    private HashMap<String, Object> geoLocationPairs = new HashMap();
    private HashMap<String, String> mobilePairs = new HashMap();

    private Subject(SubjectBuilder builder) {
        this.setOsType();
        this.setOsVersion();
        this.setDeviceModel();
        this.setDeviceVendor();
        if (builder.context != null) {
            this.setContextualParams(builder.context);
        }
        Logger.i(TAG, "Subject created successfully.", new Object[0]);
    }

    public void setContextualParams(Context context) {
        this.setLocation(context);
        this.setCarrier(context);
    }

    private void addToMobileContext(String key, String value) {
        if (key != null && value != null && !key.isEmpty() && !value.isEmpty()) {
            this.mobilePairs.put(key, value);
        }
    }

    private void addToGeoLocationContext(String key, Object value) {
        if (key != null && value != null && !key.isEmpty() || value instanceof String && !((String)value).isEmpty()) {
            this.geoLocationPairs.put(key, value);
        }
    }

    private void setDefaultTimezone() {
        TimeZone tz = Calendar.getInstance().getTimeZone();
        this.setTimezone(tz.getID());
    }

    private void setDefaultLanguage() {
        this.setLanguage(Locale.getDefault().getDisplayLanguage());
    }

    private void setOsType() {
        this.addToMobileContext("osType", "android-" + Build.VERSION.RELEASE);
    }

    private void setOsVersion() {
        this.addToMobileContext("osVersion", Build.DISPLAY);
    }

    private void setDeviceModel() {
        this.addToMobileContext("deviceModel", Build.MODEL);
    }

    private void setDeviceVendor() {
        this.addToMobileContext("deviceManufacturer", Build.MANUFACTURER);
    }

    @TargetApi(value=19)
    public void setDefaultScreenResolution(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        Point size = new Point();
        try {
            Class[] partypes = new Class[]{Point.class};
            Display.class.getMethod("getSize", partypes);
            display.getSize(size);
            this.setScreenResolution(size.x, size.y);
        }
        catch (NoSuchMethodException e) {
            Logger.e(TAG, "Display.getSize isn't available on older devices.", new Object[0]);
            this.setScreenResolution(display.getWidth(), display.getHeight());
        }
    }

    public void setLocation(Context context) {
        Location location = Util.getLocation(context);
        if (location == null) {
            Logger.e(TAG, "Location information not available.", new Object[0]);
        } else {
            this.addToGeoLocationContext("latitude", location.getLatitude());
            this.addToGeoLocationContext("longitude", location.getLongitude());
            this.addToGeoLocationContext("altitude", location.getAltitude());
            this.addToGeoLocationContext("latitudeLongitudeAccuracy", Float.valueOf(location.getAccuracy()));
            this.addToGeoLocationContext("speed", Float.valueOf(location.getSpeed()));
            this.addToGeoLocationContext("bearing", Float.valueOf(location.getBearing()));
        }
    }

    public void setCarrier(Context context) {
        String carrier = Util.getCarrier(context);
        if (carrier != null) {
            this.addToMobileContext("carrier", carrier);
        }
    }

    public void setUserId(String userId) {
        this.standardPairs.put("uid", userId);
    }

    public void setScreenResolution(int width, int height) {
        String res = Integer.toString(width) + "x" + Integer.toString(height);
        this.standardPairs.put("res", res);
    }

    public void setViewPort(int width, int height) {
        String res = Integer.toString(width) + "x" + Integer.toString(height);
        this.standardPairs.put("vp", res);
    }

    public void setColorDepth(int depth) {
        this.standardPairs.put("cd", Integer.toString(depth));
    }

    public void setTimezone(String timezone) {
        this.standardPairs.put("tz", timezone);
    }

    public void setLanguage(String language) {
        this.standardPairs.put("lang", language);
    }

    public void setIpAddress(String ipAddress) {
        this.standardPairs.put("ip", ipAddress);
    }

    public void setUseragent(String useragent) {
        this.standardPairs.put("ua", useragent);
    }

    public void setNetworkUserId(String networkUserId) {
        this.standardPairs.put("tnuid", networkUserId);
    }

    public void setDomainUserId(String domainUserId) {
        this.standardPairs.put("duid", domainUserId);
    }

    public Map<String, Object> getSubjectLocation() {
        return this.geoLocationPairs;
    }

    public Map<String, String> getSubjectMobile() {
        return this.mobilePairs;
    }

    public Map<String, String> getSubject() {
        return this.standardPairs;
    }

    public static class SubjectBuilder {
        private Context context = null;

        public SubjectBuilder context(Context context) {
            this.context = context;
            return this;
        }

        public Subject build() {
            return new Subject(this);
        }
    }
}

