/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.pushtracer.tracker;

import android.content.Context;
import com.meizu.cloud.pushsdk.pushtracer.dataload.SelfDescribingJson;
import com.meizu.cloud.pushsdk.pushtracer.dataload.TrackerDataload;
import com.meizu.cloud.pushsdk.pushtracer.emitter.Emitter;
import com.meizu.cloud.pushsdk.pushtracer.event.PushEvent;
import com.meizu.cloud.pushsdk.pushtracer.tracker.Session;
import com.meizu.cloud.pushsdk.pushtracer.tracker.Subject;
import com.meizu.cloud.pushsdk.pushtracer.utils.LogLevel;
import com.meizu.cloud.pushsdk.pushtracer.utils.Logger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Tracker {
    private static final String TAG = Tracker.class.getSimpleName();
    protected final String trackerVersion = "3.3.170123";
    protected Emitter emitter;
    protected Subject subject;
    protected Session trackerSession;
    protected String namespace;
    protected String appId;
    protected boolean base64Encoded;
    protected LogLevel level;
    protected boolean sessionContext;
    protected long sessionCheckInterval;
    protected int threadCount;
    protected TimeUnit timeUnit;
    protected AtomicBoolean dataCollection = new AtomicBoolean(true);

    public Tracker(TrackerBuilder builder) {
        this.emitter = builder.emitter;
        this.appId = builder.appId;
        this.base64Encoded = builder.base64Encoded;
        this.namespace = builder.namespace;
        this.subject = builder.subject;
        this.level = builder.logLevel;
        this.sessionContext = builder.sessionContext;
        this.sessionCheckInterval = builder.sessionCheckInterval;
        this.threadCount = builder.threadCount < 2 ? 2 : builder.threadCount;
        this.timeUnit = builder.timeUnit;
        if (this.sessionContext) {
            this.trackerSession = new Session(builder.foregroundTimeout, builder.backgroundTimeout, builder.timeUnit, builder.context);
        }
        Logger.updateLogLevel(builder.logLevel);
        Logger.i(TAG, "Tracker created successfully.", new Object[0]);
    }

    private void addEventPayload(TrackerDataload payload, List<SelfDescribingJson> context) {
        if (this.subject != null) {
            payload.addMap(new HashMap<String, Object>(this.subject.getSubject()));
        }
        SelfDescribingJson envelope = this.getFinalContext(context);
        payload.add("extra", envelope.getMap());
        Logger.i(TAG, "Adding new payload to event storage: %s", payload);
        this.emitter.add(payload);
    }

    private SelfDescribingJson getFinalContext(List<SelfDescribingJson> context) {
        if (this.sessionContext) {
            context.add(this.trackerSession.getSessionContext());
        }
        if (this.subject != null) {
            if (!this.subject.getSubjectLocation().isEmpty()) {
                SelfDescribingJson locationPayload = new SelfDescribingJson("geolocation", this.subject.getSubjectLocation());
                context.add(locationPayload);
            }
            if (!this.subject.getSubjectMobile().isEmpty()) {
                SelfDescribingJson mobilePayload = new SelfDescribingJson("mobileinfo", this.subject.getSubjectMobile());
                context.add(mobilePayload);
            }
        }
        LinkedList<Map<String, Object>> contextMaps = new LinkedList<Map<String, Object>>();
        for (SelfDescribingJson selfDescribingJson : context) {
            contextMaps.add(selfDescribingJson.getMap());
        }
        return new SelfDescribingJson("push_extra_info", contextMaps);
    }

    public void track(PushEvent event) {
        if (!this.dataCollection.get()) {
            return;
        }
        List<SelfDescribingJson> context = event.getSelfDescribingJson();
        TrackerDataload payload = event.getDataLoad();
        this.addEventPayload(payload, context);
    }

    public abstract void resumeSessionChecking();

    public abstract void pauseSessionChecking();

    public void pauseEventTracking() {
        if (this.dataCollection.compareAndSet(true, false)) {
            this.pauseSessionChecking();
            this.getEmitter().shutdown();
        }
    }

    public void resumeEventTracking() {
        if (this.dataCollection.compareAndSet(false, true)) {
            this.resumeSessionChecking();
            this.getEmitter().flush();
        }
    }

    public void restartEventTracking() {
        if (!this.dataCollection.get()) {
            return;
        }
        this.getEmitter().flush();
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public void setEmitter(Emitter emitter) {
        this.getEmitter().shutdown();
        this.emitter = emitter;
    }

    public String getTrackerVersion() {
        return this.trackerVersion;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Emitter getEmitter() {
        return this.emitter;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getAppId() {
        return this.appId;
    }

    public boolean getBase64Encoded() {
        return this.base64Encoded;
    }

    public LogLevel getLogLevel() {
        return this.level;
    }

    public Session getSession() {
        return this.trackerSession;
    }

    public boolean getDataCollection() {
        return this.dataCollection.get();
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public static class TrackerBuilder {
        protected static Class<? extends Tracker> defaultTrackerClass;
        private Class<? extends Tracker> trackerClass;
        protected final Emitter emitter;
        protected final String namespace;
        protected final String appId;
        protected final Context context;
        protected Subject subject = null;
        protected boolean base64Encoded = false;
        protected LogLevel logLevel = LogLevel.OFF;
        protected boolean sessionContext = false;
        protected long foregroundTimeout = 600L;
        protected long backgroundTimeout = 300L;
        protected long sessionCheckInterval = 15L;
        protected int threadCount = 10;
        protected TimeUnit timeUnit = TimeUnit.SECONDS;

        public TrackerBuilder(Emitter emitter, String namespace, String appId, Context context) {
            this(emitter, namespace, appId, context, defaultTrackerClass);
        }

        public TrackerBuilder(Emitter emitter, String namespace, String appId, Context context, Class<? extends Tracker> trackerClass) {
            this.emitter = emitter;
            this.namespace = namespace;
            this.appId = appId;
            this.context = context;
            this.trackerClass = trackerClass;
        }

        public TrackerBuilder subject(Subject subject) {
            this.subject = subject;
            return this;
        }

        public TrackerBuilder base64(Boolean base64) {
            this.base64Encoded = base64;
            return this;
        }

        public TrackerBuilder level(LogLevel log) {
            this.logLevel = log;
            return this;
        }

        public TrackerBuilder sessionContext(boolean sessionContext) {
            this.sessionContext = sessionContext;
            return this;
        }

        public TrackerBuilder foregroundTimeout(long timeout) {
            this.foregroundTimeout = timeout;
            return this;
        }

        public TrackerBuilder backgroundTimeout(long timeout) {
            this.backgroundTimeout = timeout;
            return this;
        }

        public TrackerBuilder sessionCheckInterval(long sessionCheckInterval) {
            this.sessionCheckInterval = sessionCheckInterval;
            return this;
        }

        public TrackerBuilder threadCount(int threadCount) {
            this.threadCount = threadCount;
            return this;
        }

        public TrackerBuilder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }
    }
}

