/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.util;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.common.util.DeviceUtils;
import com.meizu.cloud.pushsdk.common.util.Utility;
import java.util.List;

public class MzSystemUtils {
    private static final String TAG = "MzSystemUtils";

    private static String getServicesByPackageName(Context context, String packageName) {
        PackageManager packageManager = context.getPackageManager();
        ServiceInfo[] serviceInfos = null;
        try {
            serviceInfos = packageManager.getPackageInfo((String)packageName, (int)4).services;
        }
        catch (PackageManager.NameNotFoundException var4) {
            // empty catch block
        }
        if (serviceInfos == null) {
            return null;
        }
        for (int i = 0; i < serviceInfos.length; ++i) {
            if (!"com.meizu.cloud.pushsdk.pushservice.MzPushService".equals(serviceInfos[i].name)) continue;
            return serviceInfos[i].processName;
        }
        return null;
    }

    public static String getMzPushServicePackageName(Context context) {
        String packageName = context.getPackageName();
        try {
            String mzPushserviceProcessName = MzSystemUtils.getServicesByPackageName(context, "com.meizu.cloud");
            if (!TextUtils.isEmpty((CharSequence)mzPushserviceProcessName) && mzPushserviceProcessName.contains("mzservice_v1")) {
                packageName = "com.meizu.cloud";
                return packageName;
            }
        }
        catch (Exception var8) {
            var8.printStackTrace();
        }
        DebugLogger.i("SystemUtils", "startservice package name " + packageName);
        return packageName;
    }

    public static String getAppVersionName(Context context, String packageName) {
        String versionName = "";
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            versionName = pi.versionName;
            if (versionName == null || versionName.length() <= 0) {
                return "";
            }
        }
        catch (Exception e) {
            DebugLogger.e("VersionInfo", "Exception message " + e.getMessage());
            return "";
        }
        return versionName;
    }

    public static boolean compareVersion(String version1, String version2) {
        String[] versionArray1 = version1.split("\\.");
        String[] versionArray2 = version2.split("\\.");
        int minLength = Math.min(versionArray1.length, versionArray2.length);
        int diff = 0;
        for (int idx = 0; idx < minLength && (diff = versionArray1[idx].length() - versionArray2[idx].length()) == 0 && (diff = versionArray1[idx].compareTo(versionArray2[idx])) == 0; ++idx) {
        }
        diff = diff != 0 ? diff : versionArray1.length - versionArray2.length;
        return diff >= 0;
    }

    public static String findReceiver(Context paramContext, String action, String packageName) {
        if (TextUtils.isEmpty((CharSequence)action) || TextUtils.isEmpty((CharSequence)packageName)) {
            return null;
        }
        Intent localIntent = new Intent(action);
        localIntent.setPackage(packageName);
        List localList = paramContext.getPackageManager().queryBroadcastReceivers(localIntent, 0);
        if (localList != null && localList.size() > 0) {
            return ((ResolveInfo)localList.get((int)0)).activityInfo.name;
        }
        return null;
    }

    public static String getDeviceId(Context context) {
        String deviceId = DeviceUtils.getDeviceId(context);
        return deviceId;
    }

    public static boolean isBrandMeizu() {
        return Utility.isBrandMeizu();
    }
}

