/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.util;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.notification.MPushMessage;
import com.meizu.cloud.pushsdk.pushtracer.QuickTracker;
import com.meizu.cloud.pushsdk.pushtracer.event.Event;
import com.meizu.cloud.pushsdk.pushtracer.event.PushEvent;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;
import java.util.HashMap;
import java.util.Map;

public class UxIPUtils {
    private static final String TAG = "UxIPUtils";

    public static void init(Context context) {
    }

    public static void notificationEvent(Context context, String pushInfo, int pushInfoType, String taskId, String imei) {
        if (!TextUtils.isEmpty((CharSequence)taskId)) {
            UxIPUtils.onRecordMessageFlow(context, context.getPackageName(), imei, taskId, "3.3.170123", pushInfo, pushInfoType);
        }
    }

    public static void notificationEvent(Context context, Intent intent, String pushInfo, int pushInfoType) {
        UxIPUtils.notificationEvent(context, intent, "3.3.170123", pushInfo, pushInfoType);
    }

    public static void notificationEvent(Context context, Intent intent, String pushsdkVersion, String pushInfo, int pushInfoType) {
        if (!TextUtils.isEmpty((CharSequence)UxIPUtils.getTaskId(intent))) {
            UxIPUtils.onRecordMessageFlow(context, context.getPackageName(), intent.getStringExtra("statistics_imei_key"), UxIPUtils.getTaskId(intent), pushsdkVersion, pushInfo, pushInfoType);
        }
    }

    public static String getTaskId(Intent intent) {
        String taskId = intent.getStringExtra("extra_app_push_task_Id");
        if (TextUtils.isEmpty((CharSequence)taskId)) {
            try {
                MPushMessage mPushMessage = (MPushMessage)intent.getSerializableExtra("pushMessage");
                if (mPushMessage != null) {
                    taskId = mPushMessage.getTaskId();
                }
            }
            catch (Exception e) {
                taskId = "no push platform task";
                DebugLogger.e(TAG, "paese MessageV2 error " + e.getMessage());
            }
        }
        return taskId;
    }

    public static void onRecordMessageFlow(Context context, String packageName, String deviceId, String taskId, String pushsdkVersion, String pushInfo, int pushInfoType) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        propertiesMap.put("taskId", taskId);
        propertiesMap.put("deviceId", deviceId);
        propertiesMap.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        propertiesMap.put("package_name", packageName);
        propertiesMap.put("pushsdk_version", pushsdkVersion);
        propertiesMap.put("push_info", pushInfo);
        propertiesMap.put("push_info_type", String.valueOf(pushInfoType));
        UxIPUtils.onLogEvent(context, "notification_service_message", propertiesMap);
    }

    public static void onShowPushMessageEvent(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, packageName, deviceId, taskId, seqId, "show_push_message", pushTimestamp);
    }

    public static void onDeletePushMessageEvent(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, packageName, deviceId, taskId, seqId, "delete_push_message", pushTimestamp);
    }

    public static void onReceivePushMessageEvent(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, packageName, deviceId, taskId, seqId, "receive_push_event", pushTimestamp);
    }

    public static void onReceiveThroughMessage(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, packageName, deviceId, taskId, seqId, "receive_push_event", pushTimestamp);
    }

    public static void onClickPushMessageEvent(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, packageName, deviceId, taskId, seqId, "click_push_message", pushTimestamp);
    }

    public static void onInvalidPushMessage(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, packageName, deviceId, taskId, seqId, "invalid_push_message", pushTimestamp);
    }

    public static void onReceiveServerMessage(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, packageName, deviceId, taskId, seqId, "receive_server_message", pushTimestamp);
    }

    public static void onLogEvent(Context context, String packageName, String deviceId, String taskId, String seqId, String eventName, String pushTimestamp) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        propertiesMap.put("taskId", taskId);
        propertiesMap.put("deviceId", deviceId);
        propertiesMap.put("timestamp", TextUtils.isEmpty((CharSequence)pushTimestamp) ? String.valueOf(System.currentTimeMillis() / 1000L) : pushTimestamp);
        propertiesMap.put("package_name", packageName);
        propertiesMap.put("pushsdk_version", "3.3.170123");
        if (!TextUtils.isEmpty((CharSequence)seqId)) {
            propertiesMap.put("seq_id", seqId);
        }
        UxIPUtils.onLogEvent(context, eventName, propertiesMap);
    }

    public static void onLogEvent(Context context, String eventName, Map<String, String> propertiesMap) {
        DebugLogger.e(TAG, "onLogEvent eventName [" + eventName + "] properties = " + propertiesMap);
        if (!"notification_service_message".equals(eventName)) {
            QuickTracker.getAndroidTrackerClassic(context, null).track(((PushEvent.Builder)((PushEvent.Builder)((PushEvent.Builder)((PushEvent.Builder)((PushEvent.Builder)((PushEvent.Builder)((PushEvent.Builder)((Event.Builder)PushEvent.builder().eventName(eventName)).timestamp(Long.valueOf(propertiesMap.get("timestamp")))).deviceId(propertiesMap.get("deviceId"))).packageName(propertiesMap.get("package_name"))).pushsdkVersion(propertiesMap.get("pushsdk_version"))).taskId(propertiesMap.get("taskId"))).seqId(TextUtils.isEmpty((CharSequence)propertiesMap.get("seq_id")) ? "null" : propertiesMap.get("seq_id"))).messageSeq(String.valueOf(PushPreferencesUtils.getMessageSeqInCrease(context, propertiesMap.get("package_name"))))).build());
        }
    }
}

