package com.meizu.cloud.pushsdk;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.common.base.WorkReceiver;
import com.meizu.cloud.pushsdk.constants.PushConstants;
import com.meizu.cloud.pushsdk.platform.api.PushPlatformManager;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import com.meizu.cloud.pushsdk.util.UxIPUtils;

/**
 * Created by liaojinlong on 16-6-27.
 */
public class SystemReceiver extends WorkReceiver {
    private static final String TAG = "SystemReceiver";

    @Override
    public void onReceive(final Context context, final Intent intent) {
        try {
            super.onReceive(context,intent);
        } catch (Exception e){
            DebugLogger.e(TAG,"Event core error "+e.getMessage());
            UxIPUtils.onRecordMessageFlow(context,context.getPackageName(),null,null, PushManager.TAG,TAG+" "+e.getMessage(),PushConstants.WORK_RECEIVER_EVENTCORE_ERROR);
        }
    }

    @Override
    public void onHandleIntent(Context context, Intent intent) {
        try {
            if(intent != null){
                //for remove package
                if ("com.meizu.cloud.pushservice.action.PUSH_SERVICE_START".equals(intent.getAction())) {
                    restartCloudService(context);
                }
            }
        } catch (Exception e){
            DebugLogger.e(TAG,"onHandleIntent Exception "+e.getMessage());
        }
    }



    public void startPushService(Context paramContext, Intent paramIntent){
        try{
            paramContext.startService(paramIntent);
        } catch (SecurityException localSecurityException){
            DebugLogger.e(TAG,"start service error "+localSecurityException.getMessage());
        }
    }

    public void restartCloudService(Context context){
        String cloudVersionName = MzSystemUtils.getAppVersionName(context, "com.meizu.cloud");
        DebugLogger.i(TAG, context.getPackageName() + " start register cloudVersion_name " + cloudVersionName);
        Intent pushServiceIntent = new Intent();
        if("com.meizu.cloud".equals(MzSystemUtils.getMzPushServicePackageName(context))){
            DebugLogger.e(TAG,"cloud pushService start");
            pushServiceIntent.setAction("com.meizu.pushservice.action.START");
            pushServiceIntent.setClassName("com.meizu.cloud", "com.meizu.cloud.pushsdk.pushservice.MzPushService");

        } else if(!TextUtils.isEmpty(cloudVersionName) && MzSystemUtils.compareVersion(cloudVersionName, "4.5.7")){
            //Flyme 4.0 云服务4.5.7以后版本使用此方法
            //兼容5.0以下版本
            DebugLogger.e(TAG, "flyme 4.x start register cloud versionName " + cloudVersionName);
            pushServiceIntent.setPackage("com.meizu.cloud");
            pushServiceIntent.setAction(PushConstants.MZ_PUSH_ON_START_PUSH_REGISTER);

        } else if(!TextUtils.isEmpty(cloudVersionName) && cloudVersionName.startsWith("3")){
            DebugLogger.e(TAG, "flyme 3.x start register cloud versionName " + cloudVersionName);
            pushServiceIntent.setAction(PushConstants.REQUEST_REGISTRATION_INTENT);
            pushServiceIntent.setPackage("com.meizu.cloud");
            //pushServiceIntent.putExtra(PushConstants.EXTRA_APPLICATION_PENDING_INTENT, PendingIntent.getBroadcast(context, 0, new Intent(), 0));

        } else {
            DebugLogger.e(TAG, context.getPackageName() + " start register ");
            //正常逻辑
            pushServiceIntent.setClassName(context.getPackageName(), "com.meizu.cloud.pushsdk.pushservice.MzPushService");
            pushServiceIntent.setAction("com.meizu.pushservice.action.START");
        }
        startPushService(context,pushServiceIntent);
    }



}
