package com.meizu.cloud.pushsdk.common.base;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import com.meizu.cloud.pushsdk.common.event.EventCore;


/**
 * Created by zbin on 2016/1/16 0016.
 */
public abstract class WorkReceiver extends BroadcastReceiver {
    @Override
    public void onReceive(final Context context, final Intent intent) {
        EventCore.get().init(context);
        EventCore.get().post(new Runnable() {
            @Override
            public void run() {
                onHandleIntent(context, intent);
                EventCore.get().destroy();
            }
        });
    }

    public abstract void onHandleIntent(Context context, Intent intent);
}
