package com.meizu.cloud.pushsdk.common.event;

/**
 * Created by zhangbin on 16-3-24.
 */
public abstract class Event<T> {
    protected T mData;
    private String mEventName;
    private long mDelay;
    private boolean mSticky;

    public Event(String name) {
        mEventName = name;
        mDelay = 0;
        mSticky = true;
    }

    public abstract int getId();

    public <T> T getData() {
        try {
            return (T) mData;
        } catch (ClassCastException e) {}
        return null;
    }

    public Event setData(T data) {
        mData = data;
        return this;
    }

    public long getDelay() {
        return mDelay;
    }

    public Event setDelay(long delay) {
        mDelay = delay;
        return this;
    }

    public boolean isSticky() {
        return mSticky;
    }

    public Event setSticky(boolean sticky) {
        mSticky = sticky;
        return this;
    }

    protected static class Generator {
        private static int sOffset = 0;
        public static synchronized int generate() {
            return ++sOffset;
        }
    }

    @Override
    public String toString() {
        return "Event{" +
                "ID='" + mEventName + '\'' +
                ", mData=" + mData +
                '}';
    }
}
